/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTEQ;
import water.rapids.ASTNE;
import water.rapids.ASTUniOrBinOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValNum;
import water.rapids.ValStr;

abstract class ASTBinOp
extends ASTUniOrBinOp {
    ASTBinOp() {
        super(VARS2);
    }

    @Override
    ASTBinOp parse_impl(Exec E) {
        AST l = E.parse();
        AST r = E.parse();
        E.eatEnd();
        ASTBinOp res = (ASTBinOp)this.clone();
        res._asts = new AST[]{l, r};
        return res;
    }

    @Override
    void apply(Env env) {
        Frame fr;
        Vec v;
        Frame fr0 = null;
        Frame fr1 = null;
        double d0 = 0.0;
        double d1 = 0.0;
        String s0 = null;
        String s1 = null;
        int left_type = env.peekType();
        Val left = env.peek();
        int right_type = env.peekTypeAt(-1);
        Val right = env.peekAt(-1);
        switch (left_type) {
            case 3: {
                d0 = ((ValNum)left)._d;
                break;
            }
            case 1: {
                fr0 = ((ValFrame)left)._fr;
                break;
            }
            case 2: {
                s0 = ((ValStr)left)._s;
                break;
            }
            default: {
                throw H2O.unimpl("Got unusable type: " + left_type + " in binary operator " + this.opStr());
            }
        }
        switch (right_type) {
            case 3: {
                d1 = ((ValNum)right)._d;
                break;
            }
            case 1: {
                fr1 = ((ValFrame)right)._fr;
                break;
            }
            case 2: {
                s1 = ((ValStr)right)._s;
                break;
            }
            default: {
                throw H2O.unimpl("Got unusable type: " + right_type + " in binary operator " + this.opStr());
            }
        }
        if (fr0 == null && fr1 == null && s0 == null && s1 == null) {
            env.poppush(2, new ValNum(this.op(d0, d1)));
            return;
        }
        if (fr0 == null && fr1 == null) {
            env.pop();
            env.pop();
            if (s0 == null) {
                if (this.opStr().equals("==") || this.opStr().equals("!=")) {
                    env.push(new ValNum(Double.valueOf(this.op(d0, s1))));
                } else {
                    env.push(new ValStr(this.op(d0, s1)));
                }
            } else if (s1 == null) {
                if (this.opStr().equals("==") || this.opStr().equals("!=")) {
                    env.push(new ValNum(Double.valueOf(this.op(s0, d1))));
                } else {
                    env.push(new ValStr(this.op(s0, d1)));
                }
            } else {
                env.push(new ValStr(this.op(s0, s1)));
            }
            return;
        }
        if (fr0 != null && fr0.numCols() == 1 && fr0.numRows() == 1L) {
            v = fr0.anyVec();
            if (v.isEnum()) {
                s0 = v.domain()[(int)v.at(0L)];
            } else {
                d0 = v.at(0L);
            }
            fr0 = null;
        }
        if (fr1 != null && fr1.numCols() == 1 && fr1.numRows() == 1L) {
            v = fr1.anyVec();
            if (v.isEnum()) {
                s1 = v.domain()[(int)v.at(0L)];
            } else {
                d1 = v.at(0L);
            }
            fr1 = null;
        }
        if (fr0 == null && fr1 == null) {
            if (s0 == null && s1 == null) {
                env.poppush(2, new ValNum(this.op(d0, d1)));
            }
            if (s0 != null && s1 == null) {
                env.poppush(2, new ValNum(Double.valueOf(this.op(s0, d1))));
            }
            if (s0 == null && s1 != null) {
                env.poppush(2, new ValNum(Double.valueOf(this.op(d0, s1))));
            }
            if (s0 != null && s1 != null) {
                env.poppush(2, new ValNum(Double.valueOf(this.op(s0, s1))));
            }
            return;
        }
        final boolean lf = fr0 != null;
        final boolean rf = fr1 != null;
        final double df0 = d0;
        final double df1 = d1;
        final String sf0 = s0;
        final String sf1 = s1;
        int ncols = 0;
        if (fr0 != null) {
            ncols = fr0.numCols();
            if (fr1 != null) {
                if (fr0.numCols() != fr1.numCols() || fr0.numRows() != fr1.numRows()) {
                    throw new IllegalArgumentException("Arrays must be same size: LHS FRAME NUM ROWS/COLS: " + fr0.numRows() + "/" + fr0.numCols() + " vs RHS FRAME NUM ROWS/COLS: " + fr1.numRows() + "/" + fr1.numCols());
                }
                fr = new Frame(fr0).add(fr1);
            } else {
                fr = new Frame(fr0);
            }
        } else {
            ncols = fr1.numCols();
            fr = new Frame(fr1);
        }
        final ASTBinOp bin = this;
        Frame fr2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] nchks) {
                for (int i = 0; i < nchks.length; ++i) {
                    NewChunk n = nchks[i];
                    int rlen = chks[0]._len;
                    Chunk c0 = chks[i];
                    if (!c0.vec().isEnum() && (!lf || !rf || !chks[i + nchks.length].vec().isEnum()) || bin instanceof ASTEQ || bin instanceof ASTNE) {
                        for (int ro = 0; ro < rlen; ++ro) {
                            double lv = 0.0;
                            double rv = 0.0;
                            String l = null;
                            String r = null;
                            if (lf) {
                                if (chks[i].vec().isUUID() || chks[i].isNA(ro) && !bin.opStr().equals("|")) {
                                    n.addNum(Double.NaN);
                                    continue;
                                }
                                if (chks[i].vec().isEnum()) {
                                    l = chks[i].vec().domain()[(int)chks[i].atd(ro)];
                                } else {
                                    lv = chks[i].atd(ro);
                                }
                            } else if (sf0 == null) {
                                if (Double.isNaN(df0) && !bin.opStr().equals("|")) {
                                    n.addNum(Double.NaN);
                                    continue;
                                }
                                lv = df0;
                                l = null;
                            } else {
                                l = sf0;
                            }
                            if (rf) {
                                if (chks[i + (lf ? nchks.length : 0)].vec().isUUID() || chks[i].isNA(ro) && !bin.opStr().equals("|")) {
                                    n.addNum(Double.NaN);
                                    continue;
                                }
                                if (chks[i].vec().isEnum()) {
                                    r = chks[i].vec().domain()[(int)chks[i].atd(ro)];
                                } else {
                                    rv = chks[i + (lf ? nchks.length : 0)].atd(ro);
                                }
                            } else if (sf1 == null) {
                                if (Double.isNaN(df1) && !bin.opStr().equals("|")) {
                                    n.addNum(Double.NaN);
                                    continue;
                                }
                                rv = df1;
                                r = null;
                            } else {
                                r = sf1;
                            }
                            if (l == null && r == null) {
                                n.addNum(bin.op(lv, rv));
                                continue;
                            }
                            if (l == null) {
                                n.addNum(Double.valueOf(bin.op(lv, r)));
                                continue;
                            }
                            if (r == null) {
                                n.addNum(Double.valueOf(bin.op(l, rv)));
                                continue;
                            }
                            n.addNum(Double.valueOf(bin.op(l, r)));
                        }
                        continue;
                    }
                    for (int r = 0; r < rlen; ++r) {
                        n.addNA();
                    }
                }
            }
        }.doAll(ncols, fr)).outputFrame(null, (lf ? fr0 : fr1)._names, null);
        env.poppush(2, new ValFrame(fr2));
    }

    public String toString() {
        return "(" + this.opStr() + " " + Arrays.toString(this._asts) + ")";
    }
}

