/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTFrame;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTSlice;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTCbind
extends ASTUniPrefixOp {
    int argcnt;
    boolean _deepCopy;

    @Override
    String opStr() {
        return "cbind";
    }

    public ASTCbind() {
        super(new String[]{"cbind", "ary", "deepCopy", "..."});
    }

    @Override
    ASTOp make() {
        return new ASTCbind();
    }

    @Override
    ASTCbind parse_impl(Exec E) {
        ArrayList<AST> dblarys = new ArrayList<AST>();
        AST a = E.parse();
        if (a instanceof ASTId) {
            this._deepCopy = ((ASTNum)E._env.lookup((ASTId)((ASTId)a)))._d == 1.0;
        } else {
            throw new IllegalArgumentException("First argument of cbind must be TRUE or FALSE for the deepCopy flag.");
        }
        while (!E.isEnd()) {
            a = E.parse();
            if (a instanceof ASTId) {
                if (Env.staticLookup((ASTId)a) instanceof ASTFrame) {
                    dblarys.add(a);
                    continue;
                }
                throw new IllegalArgumentException("Could not find the frame with the identifier: " + ((ASTId)a)._id);
            }
            if (!(a instanceof ASTFrame) && !(a instanceof ASTSlice) && !(a instanceof ASTOp)) continue;
            dblarys.add(a);
        }
        this.argcnt = dblarys.size();
        AST[] arys = new AST[this.argcnt];
        for (int i = 0; i < dblarys.size(); ++i) {
            arys[i] = (AST)dblarys.get(i);
        }
        E.eatEnd();
        ASTCbind res = (ASTCbind)this.clone();
        res._asts = arys;
        return res;
    }

    @Override
    void apply(Env env) {
        Vec vmax = null;
        for (int i = 0; i < this.argcnt; ++i) {
            Frame t = env.peekAryAt(-i);
            if (vmax == null) {
                vmax = t.vecs()[0];
                continue;
            }
            if (t.numRows() == vmax.length()) continue;
            throw new IllegalArgumentException("Row mismatch! Expected " + String.valueOf(vmax.length()) + " but frame has " + String.valueOf(t.numRows()));
        }
        Frame first = env.peekAryAt(0 - this.argcnt + 1);
        Frame fr = this._deepCopy ? first.deepCopy(null) : new Frame(first.names(), first.vecs());
        for (int i = 1; i < this.argcnt; ++i) {
            Frame f = env.peekAryAt(i - this.argcnt + 1);
            Frame ff = fr.isCompatible(f) ? (this._deepCopy ? f.deepCopy(null) : f) : fr.makeCompatible(f);
            if (f.numCols() == 1) {
                fr.add(f.names()[0], ff.anyVec());
                continue;
            }
            fr.add(ff);
        }
        env.pop(this.argcnt);
        env.pushAry(fr);
    }
}

