/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.util.ArrayUtils;

class ASTCumSum
extends ASTUniPrefixOp {
    @Override
    String opStr() {
        return "cumsum";
    }

    @Override
    ASTOp make() {
        return new ASTCumSum();
    }

    public ASTCumSum() {
        super(new String[]{"x"});
    }

    @Override
    public void apply(Env e) {
        Frame f = e.popAry();
        if (f.numCols() != 1) {
            throw new IllegalArgumentException("Must give a single numeric column.");
        }
        if (!f.anyVec().isNumeric()) {
            throw new IllegalArgumentException("Column must be numeric.");
        }
        CumSumTask t = new CumSumTask(f.anyVec().nChunks());
        t.doAll(1, f.anyVec());
        final double[] chkSums = t._chkSums;
        Vec cumuVec = t.outputFrame().anyVec();
        new MRTask(){

            @Override
            public void map(Chunk c) {
                double d = c.cidx() == 0 ? 0.0 : chkSums[c.cidx() - 1];
                for (int i = 0; i < c._len; ++i) {
                    c.set(i, c.atd(i) + d);
                }
            }
        }.doAll(cumuVec);
        e.pushAry(new Frame(cumuVec));
    }

    private class CumSumTask
    extends MRTask<CumSumTask> {
        final int _nchks;
        double[] _chkSums;

        CumSumTask(int nchks) {
            this._nchks = nchks;
        }

        @Override
        public void setupLocal() {
            this._chkSums = new double[this._nchks];
        }

        @Override
        public void map(Chunk c, NewChunk nc) {
            double sum = 0.0;
            for (int i = 0; i < c._len; ++i) {
                if (Double.isNaN(sum += c.isNA(i) ? Double.NaN : c.atd(i))) {
                    nc.addNA();
                    continue;
                }
                nc.addNum(sum);
            }
            this._chkSums[c.cidx()] = sum;
        }

        @Override
        public void reduce(CumSumTask t) {
            if (this._chkSums != t._chkSums) {
                ArrayUtils.add(this._chkSums, t._chkSums);
            }
        }

        @Override
        public void postGlobal() {
            for (int i = 1; i < this._chkSums.length; ++i) {
                int n = i;
                this._chkSums[n] = this._chkSums[n] + this._chkSums[i - 1];
            }
        }
    }
}

