/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.ValueString;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.util.IcedHashMap;

class ASTFactor
extends ASTUniPrefixOp {
    private static int LEVELSCAP = 50000000;

    ASTFactor() {
        super(new String[]{"", "ary"});
    }

    @Override
    String opStr() {
        return "as.factor";
    }

    @Override
    ASTOp make() {
        return new ASTFactor();
    }

    @Override
    void apply(Env env) {
        Frame ary = env.popAry();
        if (ary.numCols() != 1) {
            throw new IllegalArgumentException("factor requires a single column");
        }
        Vec v0 = ary.anyVec();
        if (v0.isString()) {
            StringCollectDomain t = (StringCollectDomain)new StringCollectDomain().doAll(ary.anyVec());
            if (t.size() > LEVELSCAP) {
                throw new IllegalArgumentException("More than" + LEVELSCAP + " unique levels found. Too many levels.");
            }
            final String[] dom = t.domain();
            String[][] doms = new String[][]{dom};
            Vec v1 = ((MRTask)new MRTask(){

                @Override
                public void map(Chunk oc, NewChunk nc) {
                    ValueString v = new ValueString();
                    for (int i = 0; i < oc._len; ++i) {
                        nc.addNum(Arrays.binarySearch(dom, oc.atStr(v, i).toString()), 0);
                    }
                }
            }.doAll(1, v0)).outputFrame(ary._names, doms).anyVec();
            env.pushAry(new Frame(ary._names, new Vec[]{v1}));
            return;
        }
        if (v0.isEnum()) {
            env.pushAry(ary);
            return;
        }
        env.pushAry(new Frame(ary._names, new Vec[]{v0.toEnum()}));
    }

    private static class StringCollectDomain
    extends MRTask<StringCollectDomain> {
        private IcedHashMap<String, String> _dom;

        private StringCollectDomain() {
        }

        @Override
        public void setupLocal() {
            this._dom = new IcedHashMap();
        }

        @Override
        public void map(Chunk c) {
            ValueString v = new ValueString();
            for (int i = 0; i < c._len; ++i) {
                this._dom.putIfAbsent(c.atStr(v, i).toString(), "");
            }
        }

        @Override
        public void reduce(StringCollectDomain t) {
            if (this._dom != t._dom) {
                IcedHashMap<String, String> l = this._dom;
                IcedHashMap<String, String> r = t._dom;
                if (l.size() > r.size()) {
                    l = r;
                    r = this._dom;
                }
                for (String s : l.keySet()) {
                    r.putIfAbsent(s, "");
                }
                this._dom = r;
                t._dom = null;
            }
        }

        private String[] domain() {
            Object[] d = this._dom.keySet().toArray(new String[this.size()]);
            Arrays.sort(d);
            return d;
        }

        private int size() {
            return this._dom.size();
        }
    }
}

