/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import water.Futures;
import water.Key;
import water.fvec.AppendableVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTFilterNACols
extends ASTUniPrefixOp {
    double _frac;

    ASTFilterNACols() {
    }

    @Override
    String opStr() {
        return "filterNACols";
    }

    @Override
    ASTOp make() {
        return new ASTFilterNACols();
    }

    @Override
    ASTFilterNACols parse_impl(Exec E) {
        AST ary = E.parse();
        this._frac = E.nextDbl();
        E.eatEnd();
        ASTFilterNACols res = (ASTFilterNACols)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    public void apply(Env env) {
        Frame f = env.popAry();
        ArrayList<Integer> colsToKeep = new ArrayList<Integer>();
        int i = 0;
        double nrow = f.numRows();
        for (Vec v : f.vecs()) {
            if ((double)v.naCnt() / nrow < this._frac) {
                colsToKeep.add(i);
            }
            ++i;
        }
        Futures fs = new Futures();
        Key<Vec> key = Vec.VectorGroup.VG_LEN1.addVecs(1)[0];
        AppendableVec v = new AppendableVec((Key)key);
        NewChunk chunk = new NewChunk(v, 0);
        for (Integer aColsToKeep : colsToKeep) {
            chunk.addNum(aColsToKeep.intValue());
        }
        chunk.close(0, fs);
        Vec vec = v.close(fs);
        fs.blockForPending();
        Frame fr2 = new Frame(vec);
        env.pushAry(fr2);
    }
}

