/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.Env;
import water.rapids.ValFrame;

class ASTFrame
extends AST {
    final String _key;
    final Frame _fr;
    boolean isFrame;
    boolean _g;

    @Override
    String opStr() {
        return "%";
    }

    ASTFrame(Frame fr) {
        this._key = fr._key == null ? null : fr._key.toString();
        this._fr = fr;
    }

    ASTFrame(String key) {
        Key k = Key.make(key);
        Keyed val = (Keyed)DKV.getGet(k);
        if (val == null) {
            throw new H2OKeyNotFoundArgumentException(key);
        }
        this._key = key;
        this.isFrame = val instanceof Frame;
        Frame frame = this._fr = this.isFrame ? (Frame)val : new Frame(Key.make(), null, new Vec[]{(Vec)val});
        if (!this.isFrame && this._fr._key != null && DKV.get(this._fr._key) == null) {
            DKV.put(this._fr._key, this._fr);
        }
        this._g = true;
    }

    public String toString() {
        return "Frame with key " + this._key + ". Frame: :" + this._fr.toString();
    }

    @Override
    void exec(Env e) {
        if (this._key != null && DKV.get(this._key) != null) {
            e.lock(this._fr);
        } else {
            e.put(this._key, this._fr, this.isFrame);
        }
        if (!this.isFrame) {
            e._tmpFrames.add(this._fr);
        }
        e.push(new ValFrame(this._fr, !this.isFrame, this._g));
    }

    @Override
    int type() {
        return 1;
    }

    @Override
    String value() {
        return this._key;
    }

    boolean isGlobal() {
        return this._g;
    }

    @Override
    ASTFrame make() {
        throw H2O.unimpl();
    }
}

