/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.Futures;
import water.H2O;
import water.Key;
import water.fvec.AppendableVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTFrame;
import water.rapids.ASTFuncDef;
import water.rapids.ASTId;
import water.rapids.ASTNull;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTStatement;
import water.rapids.ASTString;
import water.rapids.Env;
import water.rapids.Exec;

public class ASTFunc
extends ASTFuncDef {
    AST[] _args;

    public ASTFunc() {
    }

    public ASTFunc(String name, String[] arg_names, Env.SymbolTable table, ASTStatement body) {
        this._name = name;
        this._arg_names = arg_names;
        this._table = table;
        this._body = body;
    }

    @Override
    ASTFunc parse_impl(Exec E) {
        int nargs = this._arg_names.length;
        AST[] args = new AST[nargs];
        for (int i = 0; i < nargs; ++i) {
            args[i] = E.parse();
        }
        E.eatEnd();
        ASTFunc res = (ASTFunc)this.clone();
        res._args = args;
        res._asts = this._asts;
        return res;
    }

    @Override
    String opStr() {
        return this._name;
    }

    @Override
    ASTOp make() {
        ASTFunc res = (ASTFunc)this.clone();
        res._name = this._name;
        res._arg_names = this._arg_names == null ? null : Arrays.copyOf(this._arg_names, this._arg_names.length);
        res._args = this._args == null ? null : Arrays.copyOf(this._args, this._args.length);
        (res._body = new ASTStatement())._asts = this._body == null ? null : Arrays.copyOf(this._body._asts, this._body._asts.length);
        return res;
    }

    @Override
    void apply(Env e) {
        Env captured = e.capture();
        for (int i = 0; i < this._args.length; ++i) {
            if (this._args[i] instanceof ASTId) {
                this._args[i] = e.lookup((ASTId)this._args[i]);
            }
            if (!(this._args[i] instanceof ASTNum || this._args[i] instanceof ASTString || this._args[i] instanceof ASTFrame || this._args[i] instanceof ASTNull)) {
                this._args[i].treeWalk(e);
                this._args[i] = e.pop2AST();
            }
            if (this._args[i] instanceof ASTNum) {
                captured.put(this._arg_names[i], 3, this._args[i].value());
                continue;
            }
            if (this._args[i] instanceof ASTString) {
                captured.put(this._arg_names[i], 2, this._args[i].value());
                continue;
            }
            if (this._args[i] instanceof ASTNull) {
                captured.put(this._arg_names[i], 99999, "()");
                continue;
            }
            if (this._args[i] instanceof ASTFrame) {
                captured.put(this._arg_names[i], ((ASTFrame)this._args[i])._fr);
                continue;
            }
            throw new IllegalArgumentException("Argument of type " + this._args[i].getClass() + " unsupported. Argument must be a String, number, Frame, or null.");
        }
        this._body.exec(captured);
        e.push(captured.peek());
        captured.popScope();
    }

    @Override
    void exec(Env e, AST ... args) {
        this._args = args;
        this.apply(e);
    }

    @Override
    double[] map(Env env, double[] in, double[] out, AST[] args) {
        Futures fs = new Futures();
        Vec[] vecs = new Vec[in.length];
        Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(vecs.length);
        for (int c = 0; c < vecs.length; ++c) {
            AppendableVec vec = new AppendableVec((Key)keys[c]);
            NewChunk chunk = new NewChunk(vec, 0);
            chunk.addNum(in[c]);
            chunk.close(0, fs);
            vecs[c] = vec.close(fs);
        }
        fs.blockForPending();
        Key local_key = Key.make();
        Frame fr = new Frame(local_key, null, vecs);
        env.addRef(fr);
        AST[] as = new AST[args == null ? 1 : args.length + 1];
        as[0] = new ASTFrame(fr);
        if (args != null) {
            System.arraycopy(args, 0, as, 1, args.length);
        }
        this.exec(env, as);
        if (env.isNum()) {
            if (out == null || out.length < 1) {
                out = new double[]{env.popDbl()};
            }
        } else if (env.isAry()) {
            fr = env.popAry();
            if (fr.numCols() > 1 && fr.numRows() != 1L) {
                throw H2O.unimpl("Number of rows returned is > 1");
            }
            if (fr.numCols() > 1) {
                out = new double[fr.numCols()];
                for (int v = 0; v < fr.vecs().length; ++v) {
                    out[v] = fr.vecs()[v].at(0L);
                }
            } else {
                Vec vec = fr.anyVec();
                if (out == null || (long)out.length < vec.length()) {
                    out = new double[(int)vec.length()];
                }
                for (long i = 0L; i < vec.length(); ++i) {
                    out[(int)i] = vec.at(i);
                }
            }
        } else {
            throw H2O.unimpl();
        }
        return out;
    }

    @Override
    public StringBuilder toString(StringBuilder sb, int d) {
        this.indent(sb, d).append(this).append(") {\n");
        this._body.toString(sb, d + 1).append("\n");
        return this.indent(sb, d).append("}");
    }
}

