/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.Key;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTString;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValFrame;

class ASTGPut
extends ASTUniPrefixOp {
    @Override
    String opStr() {
        return "gput";
    }

    ASTGPut() {
        super(new String[]{"lhs_name", "rhs"});
    }

    ASTGPut(String[] s) {
        super(s);
    }

    @Override
    ASTOp make() {
        return new ASTGPut();
    }

    @Override
    ASTGPut parse_impl(Exec E) {
        String l = E.isSpecial(E.peek()) ? E.nextStr() : E.parseID();
        ASTString lhs = new ASTString('\"', l);
        AST rhs = E.parse();
        E.eatEnd();
        ASTGPut res = (ASTGPut)this.clone();
        res._asts = new AST[]{rhs, lhs};
        return res;
    }

    @Override
    void apply(Env e) {
        Frame fr;
        Key k = Key.make(e.popStr());
        if (e.isAry()) {
            Frame f = e.popAry();
            fr = new Frame(k, f.names(), f.vecs());
        } else if (e.isNum()) {
            fr = new Frame(k, null, new Vec[]{Vec.makeCon(e.popDbl(), 1L)});
        } else if (e.isStr()) {
            Vec v = Vec.makeZero(1L);
            v.setDomain(new String[]{e.popStr()});
            fr = new Frame(k, new String[]{"C1"}, new Vec[]{v});
        } else {
            throw new IllegalArgumentException("Don't know what to do with: " + e.peek().getClass());
        }
        DKV.put(k, fr);
        e.lock(fr);
        e.put(k.toString(), fr);
        e.push(new ValFrame(fr, true));
    }
}

