/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.ValNum;

class ASTIsNA
extends ASTUniPrefixOp {
    ASTIsNA() {
    }

    @Override
    String opStr() {
        return "is.na";
    }

    @Override
    ASTOp make() {
        return new ASTIsNA();
    }

    @Override
    double op(double d) {
        return Double.isNaN(d) ? 1.0 : 0.0;
    }

    @Override
    void apply(Env env) {
        if (env.isNum()) {
            env.push(new ValNum(this.op(env.popDbl())));
            return;
        }
        Frame fr = env.popAry();
        Frame fr2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] nchks) {
                for (int i = 0; i < nchks.length; ++i) {
                    NewChunk n = nchks[i];
                    Chunk c = chks[i];
                    int rlen = c._len;
                    for (int r = 0; r < rlen; ++r) {
                        n.addNum(c.isNA(r) ? 1.0 : 0.0);
                    }
                }
            }
        }.doAll(fr.numCols(), fr)).outputFrame(fr._names, null);
        env.pushAry(fr2);
    }
}

