/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Random;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTKFold
extends ASTUniPrefixOp {
    int _nfolds;
    long _seed;

    @Override
    String opStr() {
        return "kfold_column";
    }

    @Override
    ASTOp make() {
        return new ASTKFold();
    }

    public ASTKFold() {
        super(new String[]{"x", "nfolds", "seed"});
    }

    @Override
    ASTKFold parse_impl(Exec E) {
        AST ary = E.parse();
        this._nfolds = (int)E.nextDbl();
        this._seed = (long)E.nextDbl();
        E.eatEnd();
        ASTKFold res = (ASTKFold)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    public void apply(Env e) {
        Vec foldVec = e.popAry().anyVec().makeZero();
        e.pushAry(new Frame(ASTKFold.kfoldColumn(foldVec, this._nfolds, this._seed == -1L ? new Random().nextLong() : this._seed)));
    }
}

