/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.Key;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.ASTGPut;
import water.rapids.ASTOp;
import water.rapids.Env;
import water.rapids.ValFrame;

class ASTLPut
extends ASTGPut {
    @Override
    String opStr() {
        return "lput";
    }

    ASTLPut() {
        super(new String[]{"lhs_name", "rhs"});
    }

    @Override
    ASTOp make() {
        return new ASTLPut();
    }

    @Override
    void apply(Env e) {
        Frame fr;
        Key k = Key.make(e.popStr());
        if (e.isAry()) {
            Frame f = e.popAry();
            fr = new Frame(k, f.names(), f.vecs());
        } else if (e.isNum()) {
            fr = new Frame(k, null, new Vec[]{Vec.makeCon(e.popDbl(), 1L)});
        } else if (e.isStr()) {
            Vec v = Vec.makeZero(1L);
            v.setDomain(new String[]{e.popStr()});
            fr = new Frame(k, new String[]{"C1"}, new Vec[]{v});
        } else {
            throw new IllegalArgumentException("Don't know what to do with: " + e.peek().getClass());
        }
        e.lock(fr);
        e.put(k.toString(), fr);
        e.push(new ValFrame(fr, false));
    }
}

