/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import hex.quantile.QuantileModel;
import water.DKV;
import water.H2O;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.AST;
import water.rapids.ASTId;
import water.rapids.ASTMedian;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTReducerOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValNum;

class ASTMad
extends ASTReducerOp {
    double _const;
    QuantileModel.CombineMethod _combine_method;

    ASTMad() {
        super(0.0);
    }

    @Override
    String opStr() {
        return "h2o.mad";
    }

    @Override
    ASTOp make() {
        return new ASTMad();
    }

    @Override
    double op(double d0, double d1) {
        throw H2O.unimpl();
    }

    @Override
    ASTMad parse_impl(Exec E) {
        AST ary = E.parse();
        AST a = E.parse();
        if (!(a instanceof ASTNum)) {
            throw new IllegalArgumentException("`constant` is expected to be a literal number. Got: " + a.getClass());
        }
        this._const = ((ASTNum)a)._d;
        a = E.parse();
        if (a instanceof ASTId) {
            AST b = E._env.lookup((ASTId)a);
            if (b instanceof ASTNum) {
                this._narm = ((ASTNum)b)._d == 1.0;
            } else {
                throw new IllegalArgumentException("`na.rm` is expected to be oen of %TRUE, %FALSE, %T, %F. Got: " + ((ASTId)a)._id);
            }
        }
        this._combine_method = QuantileModel.CombineMethod.valueOf(E.nextStr().toUpperCase());
        E.eatEnd();
        ASTMad res = (ASTMad)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env e) {
        Frame f = e.popAry();
        e.push(new ValNum(ASTMad.mad(f, this._combine_method, this._const)));
    }

    static double mad(Frame f, QuantileModel.CombineMethod cm, double constant) {
        Key tk = null;
        if (f._key == null) {
            tk = Key.make();
            f = new Frame(tk, f.names(), f.vecs());
            DKV.put(tk, f);
        }
        final double median = ASTMedian.median(f, cm);
        Frame abs_dev = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk nc) {
                for (int i = 0; i < c._len; ++i) {
                    nc.addNum(Math.abs((double)c.at8(i) - median));
                }
            }
        }.doAll(1, f)).outputFrame();
        if (abs_dev._key == null) {
            tk = Key.make();
            abs_dev = new Frame(tk, abs_dev.names(), abs_dev.vecs());
            DKV.put(tk, abs_dev);
        }
        double mad = ASTMedian.median(abs_dev, cm);
        DKV.remove(f._key);
        DKV.remove(abs_dev._key);
        return constant * mad;
    }
}

