/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.Futures;
import water.Key;
import water.MRTask;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValNum;

class ASTMean
extends ASTUniPrefixOp {
    double _trim = 0.0;
    boolean _narm = false;

    public ASTMean() {
        super(new String[]{"mean", "ary", "trim", "na.rm"});
    }

    @Override
    String opStr() {
        return "mean";
    }

    @Override
    ASTOp make() {
        return new ASTMean();
    }

    @Override
    ASTMean parse_impl(Exec E) {
        AST ary = E.parse();
        try {
            this._trim = ((ASTNum)E.skipWS().parse()).dbl();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Argument `trim` expected to be a number.");
        }
        AST a = E._env.lookup((ASTId)E.skipWS().parse());
        try {
            this._narm = ((ASTNum)a).dbl() == 1.0;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Argument `na.rm` expected to be a number.");
        }
        E.eatEnd();
        ASTMean res = (ASTMean)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void exec(Env e, AST[] args) {
        args[0].exec(e);
        e.put(Key.make().toString(), e.peekAry());
        if (args != null) {
            if (args.length > 3) {
                throw new IllegalArgumentException("Too many arguments passed to `mean`");
            }
            for (int i = 1; i < args.length; ++i) {
                AST a = args[i];
                if (a instanceof ASTId) {
                    this._narm = ((ASTNum)e.lookup((ASTId)a)).dbl() == 1.0;
                    continue;
                }
                if (!(a instanceof ASTNum)) continue;
                this._trim = ((ASTNum)a).dbl();
            }
        }
        this.apply(e);
    }

    @Override
    void apply(Env env) {
        if (env.isNum()) {
            return;
        }
        Frame fr = env.popAry();
        if (fr.numCols() > 1 && fr.numRows() == 1L) {
            double mean = 0.0;
            double rows = 0.0;
            for (Vec v : fr.vecs()) {
                double val = v.at(0L);
                if (Double.isNaN(val)) continue;
                mean += v.at(0L);
                rows += 1.0;
            }
            env.push(new ValNum(mean / rows));
        } else if (fr.numCols() > 1) {
            Futures fs = new Futures();
            Key<Vec> key = Vec.VectorGroup.VG_LEN1.addVecs(1)[0];
            AppendableVec v = new AppendableVec((Key)key);
            NewChunk chunk = new NewChunk(v, 0);
            for (int i = 0; i < fr.numCols(); ++i) {
                chunk.addNum(fr.vec(i).isEnum() ? Double.NaN : fr.vec(i).mean());
            }
            chunk.close(0, fs);
            Vec vec = v.close(fs);
            fs.blockForPending();
            Frame fr2 = new Frame(Key.make(), new String[]{"C1"}, new Vec[]{vec});
            DKV.put(fr2);
            env.pushAry(fr2);
        } else {
            Vec v = fr.anyVec();
            if (v.isEnum()) {
                env.push(new ValNum(Double.NaN));
                return;
            }
            if (this._narm || v.naCnt() == 0L) {
                env.push(new ValNum(v.mean()));
            } else {
                MeanNARMTask t = (MeanNARMTask)new MeanNARMTask(false).doAll(v);
                if (t._rowcnt == 0L || Double.isNaN(t._sum)) {
                    env.push(new ValNum(Double.NaN));
                } else {
                    env.push(new ValNum(t._sum / (double)t._rowcnt));
                }
            }
        }
    }

    @Override
    double[] map(Env e, double[] in, double[] out, AST[] args) {
        if (args != null) {
            if (args.length > 2) {
                throw new IllegalArgumentException("Too many arguments passed to `mean`");
            }
            for (AST a : args) {
                if (a instanceof ASTId) {
                    this._narm = ((ASTNum)e.lookup((ASTId)a)).dbl() == 1.0;
                    continue;
                }
                if (!(a instanceof ASTNum)) continue;
                this._trim = ((ASTNum)a).dbl();
            }
        }
        if (out == null || out.length < 1) {
            out = new double[1];
        }
        double s = 0.0;
        int cnt = 0;
        for (double v : in) {
            if (Double.isNaN(v)) continue;
            s += v;
            ++cnt;
        }
        out[0] = s / (double)cnt;
        return out;
    }

    static class MeanNARMTask
    extends MRTask<MeanNARMTask> {
        boolean _narm;
        double _trim;
        int _nrow;
        long _rowcnt;
        double _sum;

        MeanNARMTask(boolean narm) {
            this._narm = narm;
        }

        @Override
        public void map(Chunk c) {
            if (c.vec().isUUID()) {
                this._sum = Double.NaN;
                this._rowcnt = 0L;
                return;
            }
            if (this._narm) {
                for (int r = 0; r < c._len; ++r) {
                    if (c.isNA(r)) continue;
                    this._sum += c.atd(r);
                    ++this._rowcnt;
                }
            } else {
                for (int r = 0; r < c._len; ++r) {
                    if (c.isNA(r)) {
                        this._rowcnt = 0L;
                        this._sum = Double.NaN;
                        return;
                    }
                    this._sum += c.atd(r);
                    ++this._rowcnt;
                }
            }
        }

        @Override
        public void reduce(MeanNARMTask t) {
            this._rowcnt += t._rowcnt;
            this._sum += t._sum;
        }
    }
}

