/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.rapids.AST;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValNum;

class ASTNum
extends AST {
    final double _d;

    ASTNum(double d) {
        this._d = d;
    }

    @Override
    String opStr() {
        return "#";
    }

    @Override
    ASTNum parse_impl(Exec E) {
        try {
            return new ASTNum(Double.valueOf(E.parseID()));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Unexpected numerical argument. Badly formed AST.");
        }
    }

    public String toString() {
        return Double.toString(this._d);
    }

    @Override
    void exec(Env e) {
        e.push(new ValNum(this._d));
    }

    @Override
    int type() {
        return 3;
    }

    @Override
    String value() {
        return Double.toString(this._d);
    }

    double dbl() {
        return this._d;
    }

    @Override
    ASTNum make() {
        return new ASTNum(0.0);
    }
}

