/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.HashMap;
import java.util.Set;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTACos;
import water.rapids.ASTACosh;
import water.rapids.ASTAND;
import water.rapids.ASTASin;
import water.rapids.ASTASinh;
import water.rapids.ASTATan;
import water.rapids.ASTATanh;
import water.rapids.ASTAbs;
import water.rapids.ASTAll;
import water.rapids.ASTAny;
import water.rapids.ASTAnyFactor;
import water.rapids.ASTAnyNA;
import water.rapids.ASTApply;
import water.rapids.ASTAry;
import water.rapids.ASTAsNumeric;
import water.rapids.ASTAssign;
import water.rapids.ASTBoolList;
import water.rapids.ASTByteList;
import water.rapids.ASTCanBeCoercedToLogical;
import water.rapids.ASTCat;
import water.rapids.ASTCbind;
import water.rapids.ASTCeil;
import water.rapids.ASTCharList;
import water.rapids.ASTCharacter;
import water.rapids.ASTCos;
import water.rapids.ASTCosPi;
import water.rapids.ASTCosh;
import water.rapids.ASTCountMatches;
import water.rapids.ASTCumMax;
import water.rapids.ASTCumMin;
import water.rapids.ASTCumProd;
import water.rapids.ASTCumSum;
import water.rapids.ASTCut;
import water.rapids.ASTDay;
import water.rapids.ASTDayOfWeek;
import water.rapids.ASTDelete;
import water.rapids.ASTDiGamma;
import water.rapids.ASTDiv;
import water.rapids.ASTDoubleList;
import water.rapids.ASTEQ;
import water.rapids.ASTElse;
import water.rapids.ASTExp;
import water.rapids.ASTExpm1;
import water.rapids.ASTFactor;
import water.rapids.ASTFilterNACols;
import water.rapids.ASTFloatList;
import water.rapids.ASTFlr;
import water.rapids.ASTFoldCombine;
import water.rapids.ASTFor;
import water.rapids.ASTGE;
import water.rapids.ASTGPut;
import water.rapids.ASTGSub;
import water.rapids.ASTGT;
import water.rapids.ASTGamma;
import water.rapids.ASTGetTimeZone;
import water.rapids.ASTGroupBy;
import water.rapids.ASTHist;
import water.rapids.ASTHour;
import water.rapids.ASTId;
import water.rapids.ASTIf;
import water.rapids.ASTIfElse;
import water.rapids.ASTImpute;
import water.rapids.ASTIntDiv;
import water.rapids.ASTIntList;
import water.rapids.ASTIsCharacter;
import water.rapids.ASTIsFactor;
import water.rapids.ASTIsNA;
import water.rapids.ASTIsNumeric;
import water.rapids.ASTKFold;
import water.rapids.ASTKappa;
import water.rapids.ASTKeysLeaked;
import water.rapids.ASTLA;
import water.rapids.ASTLE;
import water.rapids.ASTLGamma;
import water.rapids.ASTLO;
import water.rapids.ASTLPut;
import water.rapids.ASTLT;
import water.rapids.ASTLength;
import water.rapids.ASTLevels;
import water.rapids.ASTListTimeZones;
import water.rapids.ASTLog;
import water.rapids.ASTLog10;
import water.rapids.ASTLog1p;
import water.rapids.ASTLog2;
import water.rapids.ASTLongList;
import water.rapids.ASTLs;
import water.rapids.ASTMMult;
import water.rapids.ASTMad;
import water.rapids.ASTMajorityVote;
import water.rapids.ASTMatch;
import water.rapids.ASTMax;
import water.rapids.ASTMean;
import water.rapids.ASTMedian;
import water.rapids.ASTMerge;
import water.rapids.ASTMillis;
import water.rapids.ASTMin;
import water.rapids.ASTMinute;
import water.rapids.ASTMktime;
import water.rapids.ASTMod;
import water.rapids.ASTModuloKFold;
import water.rapids.ASTMonth;
import water.rapids.ASTMul;
import water.rapids.ASTNAOmit;
import water.rapids.ASTNE;
import water.rapids.ASTNLevels;
import water.rapids.ASTNcol;
import water.rapids.ASTNot;
import water.rapids.ASTNrow;
import water.rapids.ASTNull;
import water.rapids.ASTNum;
import water.rapids.ASTOR;
import water.rapids.ASTPlus;
import water.rapids.ASTPop;
import water.rapids.ASTPow;
import water.rapids.ASTPow2;
import water.rapids.ASTProd;
import water.rapids.ASTQPFPC;
import water.rapids.ASTQtile;
import water.rapids.ASTRange;
import water.rapids.ASTRbind;
import water.rapids.ASTRemoveFrame;
import water.rapids.ASTRemoveVecs;
import water.rapids.ASTRename;
import water.rapids.ASTRepLen;
import water.rapids.ASTReturn;
import water.rapids.ASTRound;
import water.rapids.ASTRunif;
import water.rapids.ASTSApply;
import water.rapids.ASTScale;
import water.rapids.ASTSdev;
import water.rapids.ASTSecond;
import water.rapids.ASTSeq;
import water.rapids.ASTSeqLen;
import water.rapids.ASTSeries;
import water.rapids.ASTSetColNames;
import water.rapids.ASTSetDomain;
import water.rapids.ASTSetLevel;
import water.rapids.ASTSetTimeZone;
import water.rapids.ASTSgn;
import water.rapids.ASTShortList;
import water.rapids.ASTSignif;
import water.rapids.ASTSin;
import water.rapids.ASTSinPi;
import water.rapids.ASTSinh;
import water.rapids.ASTSlice;
import water.rapids.ASTSpan;
import water.rapids.ASTSqrt;
import water.rapids.ASTStatement;
import water.rapids.ASTStoreSize;
import water.rapids.ASTStrSplit;
import water.rapids.ASTStrSub;
import water.rapids.ASTStratifiedKFold;
import water.rapids.ASTString;
import water.rapids.ASTStringList;
import water.rapids.ASTSub;
import water.rapids.ASTSum;
import water.rapids.ASTTable;
import water.rapids.ASTTan;
import water.rapids.ASTTanPi;
import water.rapids.ASTTanh;
import water.rapids.ASTToDate;
import water.rapids.ASTToLower;
import water.rapids.ASTToUpper;
import water.rapids.ASTTranspose;
import water.rapids.ASTTriGamma;
import water.rapids.ASTTrim;
import water.rapids.ASTTrun;
import water.rapids.ASTUnique;
import water.rapids.ASTVar;
import water.rapids.ASTWeek;
import water.rapids.ASTWhich;
import water.rapids.ASTWhichMax;
import water.rapids.ASTWhile;
import water.rapids.ASTXorSum;
import water.rapids.ASTYear;
import water.rapids.ASTasDate;
import water.rapids.ASTddply;
import water.rapids.COp;
import water.rapids.Env;
import water.rapids.O;
import water.rapids.ROp;
import water.util.RandomUtils;

public abstract class ASTOp
extends AST {
    public static final HashMap<String, ASTOp> UNI_INFIX_OPS = new HashMap();
    public static final HashMap<String, ASTOp> BIN_INFIX_OPS = new HashMap();
    public static final HashMap<String, ASTOp> PREFIX_OPS = new HashMap();
    public static final HashMap<String, ASTOp> UDF_OPS = new HashMap();
    public static final HashMap<String, AST> SYMBOLS = new HashMap();
    static final String[] VARS1 = new String[]{"", "x"};
    static final String[] VARS2 = new String[]{"", "x", "y"};
    final String[] _vars;

    private static void putUniInfix(ASTOp ast) {
        UNI_INFIX_OPS.put(ast.opStr(), ast);
    }

    private static void putBinInfix(ASTOp ast) {
        BIN_INFIX_OPS.put(ast.opStr(), ast);
        SYMBOLS.put(ast.opStr(), ast);
    }

    private static void putPrefix(ASTOp ast) {
        PREFIX_OPS.put(ast.opStr(), ast);
        SYMBOLS.put(ast.opStr(), ast);
    }

    static void putUDF(ASTOp ast, String fn) {
        UDF_OPS.put(fn, ast);
        SYMBOLS.put(fn, ast);
    }

    static void removeUDF(String fn) {
        UDF_OPS.remove(fn);
    }

    public static ASTOp isOp(String id) {
        ASTOp op4 = UDF_OPS.get(id);
        if (op4 != null) {
            return op4;
        }
        return ASTOp.isBuiltinOp(id);
    }

    public static ASTOp isBuiltinOp(String id) {
        ASTOp op3 = PREFIX_OPS.get(id);
        if (op3 != null) {
            return op3;
        }
        ASTOp op2 = BIN_INFIX_OPS.get(id);
        if (op2 != null) {
            return op2;
        }
        return UNI_INFIX_OPS.get(id);
    }

    public static boolean isInfixOp(String id) {
        return BIN_INFIX_OPS.containsKey(id) || UNI_INFIX_OPS.containsKey(id);
    }

    public static boolean isUDF(String id) {
        return UDF_OPS.containsKey(id);
    }

    public static boolean isUDF(ASTOp op) {
        return ASTOp.isUDF(op.opStr());
    }

    public static Set<String> opStrs() {
        Set<String> all = UNI_INFIX_OPS.keySet();
        all.addAll(BIN_INFIX_OPS.keySet());
        all.addAll(PREFIX_OPS.keySet());
        all.addAll(UDF_OPS.keySet());
        return all;
    }

    ASTOp(String[] vars) {
        this._vars = vars;
    }

    @Override
    abstract String opStr();

    @Override
    abstract ASTOp make();

    abstract void apply(Env var1);

    double[] map(Env env, double[] in, double[] out, AST[] args) {
        throw H2O.unimpl();
    }

    @Override
    void exec(Env e) {
        throw H2O.unimpl();
    }

    void exec(Env e, AST[] args) {
        throw H2O.unimpl("No exec method for `" + this.opStr() + "` during `apply` call");
    }

    @Override
    int type() {
        return -1;
    }

    @Override
    String value() {
        throw H2O.unimpl();
    }

    public static ASTOp get(String op) {
        if (BIN_INFIX_OPS.containsKey(op)) {
            return BIN_INFIX_OPS.get(op);
        }
        if (UNI_INFIX_OPS.containsKey(op)) {
            return UNI_INFIX_OPS.get(op);
        }
        if (ASTOp.isUDF(op)) {
            return UDF_OPS.get(op);
        }
        if (PREFIX_OPS.containsKey(op)) {
            return PREFIX_OPS.get(op);
        }
        throw H2O.unimpl("Unimplemented: Could not find the operation or function " + op);
    }

    public static Vec kfoldColumn(Vec v, final int nfolds, final long seed) {
        new MRTask(){

            @Override
            public void map(Chunk c) {
                long start = c.start();
                for (int i = 0; i < c._len; ++i) {
                    int fold = Math.abs(RandomUtils.getRNG(start + seed + (long)i).nextInt()) % nfolds;
                    c.set(i, fold);
                }
            }
        }.doAll(v);
        return v;
    }

    public static Vec moduloKfoldColumn(Vec v, final int nfolds) {
        new MRTask(){

            @Override
            public void map(Chunk c) {
                long start = c.start();
                for (int i = 0; i < c._len; ++i) {
                    c.set(i, (int)((start + (long)i) % (long)nfolds));
                }
            }
        }.doAll(v);
        return v;
    }

    public static Vec stratifiedKFoldColumn(Vec y, final int nfolds, long seed) {
        if (!(y.isEnum() || y.isNumeric() && y.isInt())) {
            throw new IllegalArgumentException("stratification only applies to integer and categorical columns. Got: " + y.get_type_str());
        }
        final long[] classes = ((Vec.CollectDomain)new Vec.CollectDomain().doAll(y)).domain();
        final int nClass = y.isNumeric() ? classes.length : y.domain().length;
        final long[] seeds = new long[nClass];
        for (int i = 0; i < nClass; ++i) {
            seeds[i] = RandomUtils.getRNG(seed + (long)i).nextLong();
        }
        return ((MRTask)new MRTask(){

            private int getFoldId(long absoluteRow, long seed) {
                return Math.abs(RandomUtils.getRNG(absoluteRow + seed).nextInt()) % nfolds;
            }

            @Override
            public void map(Chunk[] y) {
                long start = y[0].start();
                for (int testFold = 0; testFold < nfolds; ++testFold) {
                    for (int classLabel = 0; classLabel < nClass; ++classLabel) {
                        for (int row = 0; row < y[0]._len; ++row) {
                            if (y[0].at8(row) != (classes == null ? (long)classLabel : classes[classLabel]) || testFold != this.getFoldId(start + (long)row, seeds[classLabel])) continue;
                            y[1].set(row, testFold);
                        }
                    }
                }
            }
        }.doAll((Frame)new Frame((Vec[])new Vec[]{y, y.makeZero()})))._fr.vec(1);
    }

    static {
        SYMBOLS.put(",", new ASTStatement());
        SYMBOLS.put("=", new ASTAssign());
        SYMBOLS.put("'", new ASTString('\'', ""));
        SYMBOLS.put("\"", new ASTString('\"', ""));
        SYMBOLS.put("%", new ASTId('%', ""));
        SYMBOLS.put("!", new ASTId('!', ""));
        SYMBOLS.put("#", new ASTNum(0.0));
        SYMBOLS.put("g", new ASTGT());
        SYMBOLS.put("G", new ASTGE());
        SYMBOLS.put("l", new ASTLT());
        SYMBOLS.put("L", new ASTLE());
        SYMBOLS.put("N", new ASTNE());
        SYMBOLS.put("n", new ASTEQ());
        SYMBOLS.put("[", new ASTSlice());
        SYMBOLS.put("{", new ASTSeries(null, null));
        SYMBOLS.put(":", new ASTSpan(new ASTNum(0.0), new ASTNum(0.0)));
        SYMBOLS.put("not", new ASTNot());
        SYMBOLS.put("_", new ASTNot());
        SYMBOLS.put("if", new ASTIf());
        SYMBOLS.put("else", new ASTElse());
        SYMBOLS.put("for", new ASTFor());
        SYMBOLS.put("while", new ASTWhile());
        SYMBOLS.put("return", new ASTReturn());
        SYMBOLS.put("del", new ASTDelete());
        SYMBOLS.put("x", new ASTMMult());
        SYMBOLS.put("t", new ASTTranspose());
        SYMBOLS.put("agg", new ASTGroupBy.AGG());
        SYMBOLS.put(")", new ASTNull());
        SYMBOLS.put("list", new ASTAry());
        SYMBOLS.put("dlist", new ASTDoubleList());
        SYMBOLS.put("llist", new ASTLongList());
        SYMBOLS.put("flist", new ASTFloatList());
        SYMBOLS.put("slist", new ASTStringList());
        SYMBOLS.put("shortlist", new ASTShortList());
        SYMBOLS.put("ilist", new ASTIntList());
        SYMBOLS.put("blist", new ASTBoolList());
        SYMBOLS.put("clist", new ASTCharList());
        SYMBOLS.put("bytelist", new ASTByteList());
        ASTOp.putUniInfix(new ASTNot());
        ASTOp.putBinInfix(new ASTPlus());
        ASTOp.putBinInfix(new ASTSub());
        ASTOp.putBinInfix(new ASTMul());
        ASTOp.putBinInfix(new ASTMMult());
        ASTOp.putBinInfix(new ASTDiv());
        ASTOp.putBinInfix(new ASTIntDiv());
        ASTOp.putBinInfix(new ASTPow());
        ASTOp.putBinInfix(new ASTPow2());
        ASTOp.putBinInfix(new ASTMod());
        ASTOp.putBinInfix(new ASTAND());
        ASTOp.putBinInfix(new ASTOR());
        ASTOp.putBinInfix(new ASTLT());
        ASTOp.putBinInfix(new ASTLE());
        ASTOp.putBinInfix(new ASTGT());
        ASTOp.putBinInfix(new ASTGE());
        ASTOp.putBinInfix(new ASTEQ());
        ASTOp.putBinInfix(new ASTNE());
        ASTOp.putBinInfix(new ASTLA());
        ASTOp.putBinInfix(new ASTLO());
        ASTOp.putPrefix(new ASTIsNA());
        ASTOp.putPrefix(new ASTNrow());
        ASTOp.putPrefix(new ASTNcol());
        ASTOp.putPrefix(new ASTLength());
        ASTOp.putPrefix(new ASTAbs());
        ASTOp.putPrefix(new ASTSgn());
        ASTOp.putPrefix(new ASTSqrt());
        ASTOp.putPrefix(new ASTCeil());
        ASTOp.putPrefix(new ASTFlr());
        ASTOp.putPrefix(new ASTLog());
        ASTOp.putPrefix(new ASTLog10());
        ASTOp.putPrefix(new ASTLog2());
        ASTOp.putPrefix(new ASTLog1p());
        ASTOp.putPrefix(new ASTExp());
        ASTOp.putPrefix(new ASTExpm1());
        ASTOp.putPrefix(new ASTGamma());
        ASTOp.putPrefix(new ASTLGamma());
        ASTOp.putPrefix(new ASTDiGamma());
        ASTOp.putPrefix(new ASTTriGamma());
        ASTOp.putPrefix(new ASTScale());
        ASTOp.putPrefix(new ASTCharacter());
        ASTOp.putPrefix(new ASTFactor());
        ASTOp.putPrefix(new ASTAsNumeric());
        ASTOp.putPrefix(new ASTIsFactor());
        ASTOp.putPrefix(new ASTIsCharacter());
        ASTOp.putPrefix(new ASTIsNumeric());
        ASTOp.putPrefix(new ASTAnyFactor());
        ASTOp.putPrefix(new ASTCanBeCoercedToLogical());
        ASTOp.putPrefix(new ASTAnyNA());
        ASTOp.putPrefix(new ASTRound());
        ASTOp.putPrefix(new ASTSignif());
        ASTOp.putPrefix(new ASTTrun());
        ASTOp.putPrefix(new ASTLPut());
        ASTOp.putPrefix(new ASTGPut());
        ASTOp.putPrefix(new ASTTranspose());
        ASTOp.putPrefix(new ASTCos());
        ASTOp.putPrefix(new ASTSin());
        ASTOp.putPrefix(new ASTTan());
        ASTOp.putPrefix(new ASTACos());
        ASTOp.putPrefix(new ASTASin());
        ASTOp.putPrefix(new ASTATan());
        ASTOp.putPrefix(new ASTCosh());
        ASTOp.putPrefix(new ASTSinh());
        ASTOp.putPrefix(new ASTTanh());
        ASTOp.putPrefix(new ASTACosh());
        ASTOp.putPrefix(new ASTASinh());
        ASTOp.putPrefix(new ASTATanh());
        ASTOp.putPrefix(new ASTCosPi());
        ASTOp.putPrefix(new ASTSinPi());
        ASTOp.putPrefix(new ASTTanPi());
        ASTOp.putPrefix(new ASTMin());
        ASTOp.putPrefix(new ASTMax());
        ASTOp.putPrefix(new ASTSum());
        ASTOp.putPrefix(new ASTProd());
        ASTOp.putPrefix(new ASTSdev());
        ASTOp.putPrefix(new ASTVar());
        ASTOp.putPrefix(new ASTMean());
        ASTOp.putPrefix(new ASTMedian());
        ASTOp.putPrefix(new ASTMad());
        ASTOp.putPrefix(new ASTKFold());
        ASTOp.putPrefix(new ASTModuloKFold());
        ASTOp.putPrefix(new ASTStratifiedKFold());
        ASTOp.putPrefix(new ASTPop());
        ASTOp.putPrefix(new ASTSetLevel());
        ASTOp.putPrefix(new ASTMatch());
        ASTOp.putPrefix(new ASTRename());
        ASTOp.putPrefix(new ASTSeq());
        ASTOp.putPrefix(new ASTSeqLen());
        ASTOp.putPrefix(new ASTRepLen());
        ASTOp.putPrefix(new ASTQtile());
        ASTOp.putPrefix(new ASTCbind());
        ASTOp.putPrefix(new ASTRbind());
        ASTOp.putPrefix(new ASTTable());
        ASTOp.putPrefix(new ASTIfElse());
        ASTOp.putPrefix(new ASTApply());
        ASTOp.putPrefix(new ASTSApply());
        ASTOp.putPrefix(new ASTddply());
        ASTOp.putPrefix(new ASTMerge());
        ASTOp.putPrefix(new ASTGroupBy());
        ASTOp.putPrefix(new ASTCumSum());
        ASTOp.putPrefix(new ASTCumProd());
        ASTOp.putPrefix(new ASTCumMin());
        ASTOp.putPrefix(new ASTCumMax());
        ASTOp.putPrefix(new ASTUnique());
        ASTOp.putPrefix(new ASTXorSum());
        ASTOp.putPrefix(new ASTRunif());
        ASTOp.putPrefix(new ASTCut());
        ASTOp.putPrefix(new ASTLs());
        ASTOp.putPrefix(new ASTSetColNames());
        ASTOp.putPrefix(new ASTRemoveFrame());
        ASTOp.putPrefix(new ASTasDate());
        ASTOp.putPrefix(new ASTToDate());
        ASTOp.putPrefix(new ASTCat());
        ASTOp.putPrefix(new ASTYear());
        ASTOp.putPrefix(new ASTMonth());
        ASTOp.putPrefix(new ASTWeek());
        ASTOp.putPrefix(new ASTDay());
        ASTOp.putPrefix(new ASTDayOfWeek());
        ASTOp.putPrefix(new ASTHour());
        ASTOp.putPrefix(new ASTMinute());
        ASTOp.putPrefix(new ASTSecond());
        ASTOp.putPrefix(new ASTMillis());
        ASTOp.putPrefix(new ASTMktime());
        ASTOp.putPrefix(new ASTListTimeZones());
        ASTOp.putPrefix(new ASTGetTimeZone());
        ASTOp.putPrefix(new ASTFoldCombine());
        ASTOp.putPrefix(new ASTSetTimeZone());
        ASTOp.putPrefix(new COp());
        ASTOp.putPrefix(new ROp());
        ASTOp.putPrefix(new O());
        ASTOp.putPrefix(new ASTImpute());
        ASTOp.putPrefix(new ASTQPFPC());
        ASTOp.putPrefix(new ASTStoreSize());
        ASTOp.putPrefix(new ASTKeysLeaked());
        ASTOp.putPrefix(new ASTAll());
        ASTOp.putPrefix(new ASTAny());
        ASTOp.putPrefix(new ASTRange());
        ASTOp.putPrefix(new ASTNLevels());
        ASTOp.putPrefix(new ASTLevels());
        ASTOp.putPrefix(new ASTHist());
        ASTOp.putPrefix(new ASTNAOmit());
        ASTOp.putPrefix(new ASTGSub());
        ASTOp.putPrefix(new ASTStrSplit());
        ASTOp.putPrefix(new ASTCountMatches());
        ASTOp.putPrefix(new ASTStrSub());
        ASTOp.putPrefix(new ASTToLower());
        ASTOp.putPrefix(new ASTToUpper());
        ASTOp.putPrefix(new ASTTrim());
        ASTOp.putPrefix(new ASTFilterNACols());
        ASTOp.putPrefix(new ASTSetDomain());
        ASTOp.putPrefix(new ASTRemoveVecs());
        ASTOp.putPrefix(new ASTKappa());
        ASTOp.putPrefix(new ASTWhich());
        ASTOp.putPrefix(new ASTWhichMax());
        ASTOp.putPrefix(new ASTMajorityVote());
    }
}

