/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.Futures;
import water.Key;
import water.fvec.AppendableVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTRange
extends ASTUniPrefixOp {
    @Override
    String opStr() {
        return "range";
    }

    ASTRange() {
        super(new String[]{"x"});
    }

    @Override
    ASTOp make() {
        return new ASTRange();
    }

    @Override
    ASTRange parse_impl(Exec E) {
        AST ary = E.parse();
        AST a = E.parse();
        E.eatEnd();
        ASTRange res = (ASTRange)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env env) {
        Frame f = env.popAry();
        if (f.numCols() != 1) {
            throw new IllegalArgumentException("Must be a single numeric column.");
        }
        if (!f.anyVec().isNumeric()) {
            throw new IllegalArgumentException("Column must be numeric.");
        }
        Futures fs = new Futures();
        Key<Vec> k = Vec.VectorGroup.VG_LEN1.addVecs(1)[0];
        AppendableVec v = new AppendableVec((Key)k);
        NewChunk c = new NewChunk(v, 0);
        c.addNum(f.anyVec().min());
        c.addNum(f.anyVec().max());
        c.close(0, fs);
        Vec vec = v.close(fs);
        fs.blockForPending();
        Frame f2 = new Frame(vec);
        env.pushAry(f2);
    }
}

