/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.CountedCompleter;
import water.DKV;
import water.H2O;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTFrame;
import water.rapids.ASTId;
import water.rapids.ASTOp;
import water.rapids.ASTSlice;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValFrame;

class ASTRbind
extends ASTUniPrefixOp {
    int argcnt;

    @Override
    String opStr() {
        return "rbind";
    }

    public ASTRbind() {
        super(new String[]{"rbind", "ary", "..."});
    }

    @Override
    ASTOp make() {
        return new ASTRbind();
    }

    @Override
    ASTRbind parse_impl(Exec E) {
        ArrayList<AST> dblarys = new ArrayList<AST>();
        while (!E.isEnd()) {
            AST a = E.parse();
            if (a instanceof ASTId) {
                if (Env.staticLookup((ASTId)a) instanceof ASTFrame) {
                    dblarys.add(a);
                    continue;
                }
                throw new IllegalArgumentException("Could not find the frame with the identifier: " + ((ASTId)a)._id);
            }
            if (!(a instanceof ASTFrame) && !(a instanceof ASTSlice) && !(a instanceof ASTOp)) continue;
            dblarys.add(a);
        }
        Collections.reverse(dblarys);
        this.argcnt = dblarys.size();
        E.eatEnd();
        ASTRbind res = (ASTRbind)this.clone();
        res._asts = dblarys.toArray(new AST[this.argcnt]);
        return res;
    }

    private String get_type(byte t) {
        switch (t) {
            case 4: {
                return "factor";
            }
            case 3: {
                return "numeric";
            }
            case 2: {
                return "String";
            }
            case 5: {
                return "time";
            }
            case 1: {
                return "UUID";
            }
        }
        return "bad";
    }

    @Override
    void apply(Env env) {
        if (this.argcnt == 1) {
            return;
        }
        Frame f1 = env.peekAry();
        for (int i = 1; i < this.argcnt; ++i) {
            Frame t = env.peekAryAt(-i);
            if (t.numCols() != f1.numCols()) {
                throw new IllegalArgumentException("Column mismatch! Expected " + f1.numCols() + " but frame has " + t.numCols());
            }
            for (int c = 0; c < f1.numCols(); ++c) {
                if (f1.vec(c).get_type() == t.vec(c).get_type() || f1.vec(c).get_type() == 0 || t.vec(c).get_type() == 0) continue;
                throw new IllegalArgumentException("Column type mismatch on column #" + c + "! Expected type " + this.get_type(f1.vec(c).get_type()) + " but vec has type " + this.get_type(t.vec(c).get_type()));
            }
        }
        ParallelRbinds t = new ParallelRbinds(env, this.argcnt);
        H2O.submitTask(t).join();
        env.poppush(this.argcnt, new ValFrame(new Frame(f1.names(), t._vecs)));
    }

    public static class ParallelRbinds
    extends H2O.H2OCountedCompleter {
        private final Env _env;
        private final int _argcnt;
        private final AtomicInteger _ctr;
        private int _maxP = 100;
        private long[] _espc;
        private Vec[] _vecs;

        ParallelRbinds(Env e, int argcnt) {
            this._env = e;
            this._argcnt = argcnt;
            this._ctr = new AtomicInteger(this._maxP - 1);
        }

        @Override
        protected void compute2() {
            int i;
            this.addToPendingCount(this._env.peekAry().numCols() - 1);
            int nchks = 0;
            for (int i2 = 0; i2 < this._argcnt; ++i2) {
                nchks += this._env.peekAryAt(-i2).anyVec().nChunks();
            }
            this._espc = new long[nchks + 1];
            int coffset = this._env.peekAry().anyVec().nChunks();
            long[] first_espc = this._env.peekAry().anyVec().get_espc();
            System.arraycopy(first_espc, 0, this._espc, 0, first_espc.length);
            for (int i3 = 1; i3 < this._argcnt; ++i3) {
                long roffset = this._espc[coffset];
                long[] espc = this._env.peekAryAt(-i3).anyVec().get_espc();
                for (int j = 1; j < espc.length; ++j) {
                    this._espc[coffset + j] = roffset + espc[j];
                }
                coffset += this._env.peekAryAt(-i3).anyVec().nChunks();
            }
            Key<Vec>[] keys = this._env.peekAry().anyVec().group().addVecs(this._env.peekAry().numCols());
            this._vecs = new Vec[keys.length];
            for (i = 0; i < this._vecs.length; ++i) {
                this._vecs[i] = new Vec(keys[i], this._espc, null, this._env.peekAry().vec(i).get_type());
            }
            for (i = 0; i < Math.min(this._maxP, this._vecs.length); ++i) {
                this.forkVecTask(i);
            }
        }

        private void forkVecTask(int i) {
            Vec[] vecs = new Vec[this._argcnt];
            for (int j = 0; j < this._argcnt; ++j) {
                vecs[j] = this._env.peekAryAt(-j).vec(i);
            }
            new RbindTask(new Callback(), vecs, this._vecs[i], this._espc).fork();
        }

        private class Callback
        extends H2O.H2OCallback {
            public Callback() {
                super(ParallelRbinds.this);
            }

            public void callback(H2O.H2OCountedCompleter h2OCountedCompleter) {
                int i = ParallelRbinds.this._ctr.incrementAndGet();
                if (i < ParallelRbinds.this._vecs.length) {
                    ParallelRbinds.this.forkVecTask(i);
                }
            }
        }
    }

    private static class RbindTask
    extends H2O.H2OCountedCompleter<RbindTask> {
        final transient Vec[] _vecs;
        final Vec _v;
        final long[] _espc;
        String[] _dom;

        RbindTask(H2O.H2OCountedCompleter cc, Vec[] vecs, Vec v, long[] espc) {
            super(cc);
            this._vecs = vecs;
            this._v = v;
            this._espc = espc;
        }

        private static Map<Integer, String> invert(Map<String, Integer> map) {
            HashMap<Integer, String> inv = new HashMap<Integer, String>();
            for (Map.Entry<String, Integer> e : map.entrySet()) {
                inv.put(e.getValue(), e.getKey());
            }
            return inv;
        }

        @Override
        protected void compute2() {
            this.addToPendingCount(this._vecs.length - 1);
            boolean isEnum = this._vecs[0].domain() != null;
            int[][] emaps = new int[this._vecs.length][];
            if (isEnum) {
                HashMap<String, Integer> dmap = new HashMap<String, Integer>();
                int c = 0;
                for (int i = 0; i < this._vecs.length; ++i) {
                    if (this._vecs[i].get_type() == 0) continue;
                    emaps[i] = new int[this._vecs[i].domain().length];
                    for (int j = 0; j < emaps[i].length; ++j) {
                        if (!dmap.containsKey(this._vecs[i].domain()[j])) {
                            int n = c++;
                            emaps[i][j] = n;
                            dmap.put(this._vecs[i].domain()[j], n);
                            continue;
                        }
                        emaps[i][j] = dmap.get(this._vecs[i].domain()[j]);
                    }
                }
                this._dom = new String[dmap.size()];
                HashMap inv = (HashMap)RbindTask.invert(dmap);
                for (int s = 0; s < this._dom.length; ++s) {
                    this._dom[s] = (String)inv.get(s);
                }
            }
            int offset = 0;
            for (int i = 0; i < this._vecs.length; ++i) {
                new RbindMRTask(this, emaps[i], this._v, offset).asyncExec(this._vecs[i]);
                offset += this._vecs[i].nChunks();
            }
        }

        @Override
        public void onCompletion(CountedCompleter cc) {
            this._v.setDomain(this._dom);
            DKV.put(this._v);
        }
    }

    private static class RbindMRTask
    extends MRTask<RbindMRTask> {
        private final int[] _emap;
        private final int _chunkOffset;
        private final Vec _v;

        RbindMRTask(H2O.H2OCountedCompleter hc, int[] emap, Vec v, int offset) {
            super(hc);
            this._emap = emap;
            this._v = v;
            this._chunkOffset = offset;
        }

        @Override
        public void map(Chunk cs) {
            int idx = this._chunkOffset + cs.cidx();
            Key ckey = Vec.chunkKey(this._v._key, idx);
            if (this._emap != null) {
                assert (!cs.hasFloat()) : "Input chunk (" + cs.getClass() + ") has float, but is expected to be enum";
                NewChunk nc = new NewChunk(this._v, idx);
                for (int r = 0; r < cs._len; ++r) {
                    if (cs.isNA(r)) {
                        nc.addNA();
                        continue;
                    }
                    nc.addNum(this._emap[(int)cs.at8(r)], 0);
                }
                nc.close(this._fs);
            } else {
                Chunk oc = (Chunk)cs.clone();
                oc.setStart(-1L);
                oc.setVec(null);
                oc.setBytes((byte[])cs.getBytes().clone());
                DKV.put(ckey, oc, this._fs, true);
            }
        }
    }
}

