/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTDoubleList;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.ASTVar;
import water.rapids.Env;
import water.rapids.Exec;

class ASTScale
extends ASTUniPrefixOp {
    boolean _center = true;
    double[] _centers;
    boolean _scale = true;
    double[] _scales;

    ASTScale() {
        super(new String[]{"ary", "center", "scale"});
    }

    @Override
    String opStr() {
        return "scale";
    }

    @Override
    ASTOp make() {
        return new ASTScale();
    }

    @Override
    ASTScale parse_impl(Exec E) {
        AST ary = E.parse();
        this.parseArg(E, true);
        this.parseArg(E, false);
        E.eatEnd();
        ASTScale res = (ASTScale)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    private void parseArg(Exec E, boolean center) {
        if (center) {
            AST a = E.parse();
            if (a instanceof ASTId) {
                this._center = ((ASTNum)E._env.lookup((ASTId)((ASTId)a)))._d == 1.0;
            } else if (a instanceof ASTDoubleList) {
                this._centers = ((ASTDoubleList)a)._d;
            }
        } else {
            AST a = E.parse();
            if (a instanceof ASTId) {
                this._scale = ((ASTNum)E._env.lookup((ASTId)((ASTId)a)))._d == 1.0;
            } else if (a instanceof ASTDoubleList) {
                this._scales = ((ASTDoubleList)a)._d;
            }
        }
    }

    @Override
    void apply(Env env) {
        Frame fr = env.popAry();
        if (this._centers != null && this._centers.length != fr.numCols()) {
            throw new IllegalArgumentException("`centers` must be logical or have length equal to the number of columns in the dataset.");
        }
        if (this._scales != null && this._scales.length != fr.numCols()) {
            throw new IllegalArgumentException("`scales` must be logical or have length equal to the number of columns in the dataset.");
        }
        final boolean use_mean = this._centers == null && this._center;
        final double[] centers = this._centers;
        final boolean use_sig = this._scales == null && this._scale;
        final boolean use_rms = !use_mean && this._scale;
        final double[] scales = this._scales;
        if (!this._center && !this._scale && this._centers == null && this._scales == null) {
            env.pushAry(fr);
            return;
        }
        boolean doCenter = use_mean || this._centers != null;
        boolean doScale = use_sig || use_rms || this._scales != null;
        Frame centered = new Frame(fr);
        if (doCenter) {
            centered = ((MRTask)new MRTask(){

                @Override
                public void map(Chunk[] cs, NewChunk[] ncs) {
                    int rows = cs[0]._len;
                    int cols = cs.length;
                    for (int r = 0; r < rows; ++r) {
                        for (int c = 0; c < cols; ++c) {
                            if (cs[c].isNA(r)) {
                                ncs[c].addNA();
                                continue;
                            }
                            if (cs[c].vec().isEnum()) {
                                ncs[c].addNum(cs[c].at8(r), 0);
                                continue;
                            }
                            double numer = cs[c].atd(r) - (use_mean ? cs[c].vec().mean() : (centers == null ? 0.0 : centers[c]));
                            ncs[c].addNum(numer);
                        }
                    }
                }
            }.doAll(fr.numCols(), fr)).outputFrame(fr.names(), fr.domains());
        }
        double[] rms_vals = null;
        if (use_rms) {
            rms_vals = new double[fr.numCols()];
            double nrows = fr.numRows();
            for (int i = 0; i < rms_vals.length; ++i) {
                Vec v = centered.vecs()[i];
                ASTVar.CovarTask t = (ASTVar.CovarTask)new ASTVar.CovarTask(0.0, 0.0).doAll(new Frame(v, v));
                rms_vals[i] = Math.sqrt(t._ss / (nrows - 1.0));
            }
        }
        final double[] rms = rms_vals;
        Frame scaled = new Frame(centered);
        if (doScale) {
            scaled = ((MRTask)new MRTask(){

                @Override
                public void map(Chunk[] cs, NewChunk[] ncs) {
                    int rows = cs[0]._len;
                    int cols = cs.length;
                    for (int r = 0; r < rows; ++r) {
                        for (int c = 0; c < cols; ++c) {
                            if (cs[c].isNA(r)) {
                                ncs[c].addNA();
                                continue;
                            }
                            if (cs[c].vec().isEnum()) {
                                ncs[c].addNum(cs[c].at8(r), 0);
                                continue;
                            }
                            double denom = cs[c].atd(r) / (use_rms ? rms[c] : (use_sig ? cs[c].vec().sigma() : (scales == null ? 1.0 : scales[c])));
                            ncs[c].addNum(denom);
                        }
                    }
                }
            }.doAll(centered.numCols(), centered)).outputFrame(centered.names(), centered.domains());
        }
        env.pushAry(scaled);
    }
}

