/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.Futures;
import water.Key;
import water.fvec.AppendableVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.ASTVar;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValNum;

class ASTSdev
extends ASTUniPrefixOp {
    boolean _narm = false;

    public ASTSdev() {
        super(new String[]{"sd", "ary", "na.rm"});
    }

    @Override
    String opStr() {
        return "sd";
    }

    @Override
    ASTOp make() {
        return new ASTSdev();
    }

    @Override
    ASTSdev parse_impl(Exec E) {
        AST ary = E.parse();
        AST a = E._env.lookup((ASTId)E.parse());
        this._narm = ((ASTNum)a).dbl() == 1.0;
        E.eatEnd();
        ASTSdev res = (ASTSdev)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env env) {
        if (env.isNum()) {
            env.poppush(1, new ValNum(Double.NaN));
        } else {
            Frame fr = env.peekAry();
            if (fr.numCols() > 1) {
                Futures fs = new Futures();
                Key<Vec> key = Vec.VectorGroup.VG_LEN1.addVecs(1)[0];
                AppendableVec v = new AppendableVec((Key)key);
                NewChunk chunk = new NewChunk(v, 0);
                for (int i = 0; i < fr.numCols(); ++i) {
                    chunk.addNum(fr.vec(i).isEnum() ? Double.NaN : fr.vec(i).sigma());
                }
                chunk.close(0, fs);
                Vec vec = v.close(fs);
                fs.blockForPending();
                Frame fr2 = new Frame(Key.make(), new String[]{"C1"}, new Vec[]{vec});
                DKV.put(fr2);
                env.pushAry(fr2);
            } else {
                double sig = fr.anyVec().isEnum() ? Double.NaN : Math.sqrt(ASTVar.getVar(fr.anyVec(), this._narm));
                env.poppush(1, new ValNum(sig));
            }
        }
    }
}

