/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTSeqLen
extends ASTUniPrefixOp {
    double _length;

    @Override
    String opStr() {
        return "seq_len";
    }

    ASTSeqLen() {
        super(new String[]{"seq_len", "n"});
    }

    @Override
    ASTOp make() {
        return new ASTSeqLen();
    }

    @Override
    ASTSeqLen parse_impl(Exec E) {
        try {
            this._length = E.nextDbl();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Argument `n` expected to be a number.");
        }
        E.eatEnd();
        ASTSeqLen res = (ASTSeqLen)this.clone();
        res._asts = new AST[0];
        return res;
    }

    @Override
    void apply(Env env) {
        int len = (int)Math.ceil(this._length);
        if (len <= 0) {
            throw new IllegalArgumentException("Error in seq_len(" + len + "): argument must be coercible to positive integer");
        }
        Frame fr = new Frame(new String[]{"c"}, new Vec[]{Vec.makeSeq((long)len, true)});
        env.pushAry(fr);
    }
}

