/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTSpan;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValSeries;

class ASTSeries
extends AST {
    final long[] _idxs;
    final ASTSpan[] _spans;
    final double[] _d;
    boolean _isCol;
    boolean _isRow;
    int[] _order;

    @Override
    String opStr() {
        return "{";
    }

    ASTSeries(long[] idxs, double[] d, ASTSpan[] spans) {
        this._idxs = idxs;
        this._d = d;
        this._spans = spans;
    }

    ASTSeries(long[] idxs, ASTSpan[] spans) {
        this._idxs = idxs;
        this._d = null;
        this._spans = spans;
    }

    @Override
    ASTSeries parse_impl(Exec E) {
        int i;
        ArrayList<Long> l_idxs = new ArrayList<Long>();
        ArrayList<ASTSpan> s_spans = new ArrayList<ASTSpan>();
        if (!E.hasNext()) {
            throw new IllegalArgumentException("End of input unexpected. Badly formed AST.");
        }
        String[] strs = E.parseString('}').split(";");
        this._order = new int[strs.length];
        int o = 0;
        for (String s : strs) {
            if (s.charAt(0) == '(') {
                this._order[o] = 0;
                try {
                    s_spans.add((ASTSpan)new Exec(s, null).parse());
                }
                catch (ClassCastException e) {
                    try {
                        ASTOp anum = (ASTOp)new Exec(s, null).parse();
                        long n = (long)anum.treeWalk(E._env).popDbl();
                        this._order[o] = 1;
                        l_idxs.add(n);
                    }
                    catch (ClassCastException e2) {
                        throw new IllegalArgumentException("AST in sequence did not evaluate to a range or number.\n Only (: min max), #, and ASTs that evaluate to # are valid.");
                    }
                }
                ++o;
                continue;
            }
            this._order[o++] = 1;
            if (s.charAt(0) == '#') {
                s = s.substring(1, s.length());
            }
            try {
                Long.valueOf(s);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid input. Value was not long or int: " + s);
            }
            l_idxs.add(Long.valueOf(s));
        }
        long[] idxs = new long[l_idxs.size()];
        ASTSpan[] spans = new ASTSpan[s_spans.size()];
        for (i = 0; i < idxs.length; ++i) {
            idxs[i] = (Long)l_idxs.get(i);
        }
        for (i = 0; i < spans.length; ++i) {
            spans[i] = (ASTSpan)s_spans.get(i);
        }
        ASTSeries aa = new ASTSeries(idxs, spans);
        aa._order = this._order;
        return aa;
    }

    boolean contains(long a) {
        if (this._spans != null) {
            for (ASTSpan s : this._spans) {
                if (!s.contains(a)) continue;
                return true;
            }
        }
        if (this._idxs != null) {
            for (long l : this._idxs) {
                if (l != a) continue;
                return true;
            }
        }
        return false;
    }

    boolean isColSelector() {
        return this._isCol;
    }

    boolean isRowSelector() {
        return this._isRow;
    }

    ASTSeries setSlice(boolean row, boolean col) {
        this._isRow = row;
        this._isCol = col;
        return this;
    }

    @Override
    void exec(Env e) {
        ValSeries v = new ValSeries(this._idxs, this._d, this._spans);
        v._order = this._order;
        v.setSlice(this._isRow, this._isCol);
        e.push(v);
    }

    @Override
    String value() {
        return null;
    }

    @Override
    int type() {
        return 6;
    }

    public String toString() {
        String res = "c(";
        if (this._spans != null) {
            for (ASTSpan s : this._spans) {
                res = res + s.toString();
                res = res + ",";
            }
            if (this._idxs == null) {
                res = res.substring(0, res.length() - 1);
            }
        }
        if (this._idxs != null) {
            for (long l : this._idxs) {
                res = res + l;
                res = res + ",";
            }
            res = res.substring(0, res.length() - 1);
        }
        res = res + ")";
        return res;
    }

    long[] toArray() {
        int res_length = 0;
        if (this._spans != null) {
            for (ASTSpan s : this._spans) {
                res_length += (int)s._max - (int)s._min + 1;
            }
        }
        if (this._idxs != null) {
            res_length += this._idxs.length;
        }
        long[] res = new long[res_length];
        int cur = 0;
        if (this._spans != null) {
            for (ASTSpan s : this._spans) {
                long[] l = s.toArray();
                for (int i = 0; i < l.length; ++i) {
                    res[cur++] = l[i];
                }
            }
        }
        if (this._idxs != null) {
            for (int i = 0; i < this._idxs.length; ++i) {
                res[cur++] = this._idxs[i];
            }
        }
        return res;
    }

    @Override
    ASTSeries make() {
        return new ASTSeries(null, null);
    }
}

