/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTString;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValFrame;

class ASTSetLevel
extends ASTUniPrefixOp {
    private String _lvl;

    ASTSetLevel() {
        super(new String[]{"setLevel", "x", "level"});
    }

    @Override
    String opStr() {
        return "setLevel";
    }

    @Override
    ASTOp make() {
        return new ASTSetLevel();
    }

    @Override
    ASTSetLevel parse_impl(Exec E) {
        AST ary = E.parse();
        this._lvl = ((ASTString)E.parse())._s;
        E.eatEnd();
        ASTSetLevel res = (ASTSetLevel)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env env) {
        Frame fr = env.peekAry();
        if (fr.numCols() != 1) {
            throw new IllegalArgumentException("`setLevel` works on a single column at a time.");
        }
        String[] doms = (String[])fr.anyVec().domain().clone();
        if (doms == null) {
            throw new IllegalArgumentException("Cannot set the level on a non-factor column!");
        }
        final int idx = Arrays.asList(doms).indexOf(this._lvl);
        if (idx == -1) {
            throw new IllegalArgumentException("Did not find level `" + this._lvl + "` in the column.");
        }
        Frame fr2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk nc) {
                for (int i = 0; i < c._len; ++i) {
                    nc.addNum(idx);
                }
            }
        }.doAll(1, fr.anyVec())).outputFrame(null, fr.names(), fr.domains());
        env.poppush(1, new ValFrame(fr2));
    }
}

