/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Set;
import org.joda.time.DateTimeZone;
import water.MRTask;
import water.parser.ParseTime;
import water.rapids.ASTOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTSetTimeZone
extends ASTOp {
    String _tz;

    ASTSetTimeZone() {
        super(new String[]{"tz"});
    }

    @Override
    String opStr() {
        return "setTimeZone";
    }

    @Override
    ASTOp make() {
        return new ASTSetTimeZone();
    }

    @Override
    ASTSetTimeZone parse_impl(Exec E) {
        this._tz = E.nextStr();
        E.eatEnd();
        return (ASTSetTimeZone)this.clone();
    }

    @Override
    void apply(Env e) {
        Set idSet = DateTimeZone.getAvailableIDs();
        if (!idSet.contains(this._tz)) {
            throw new IllegalArgumentException("Unacceptable timezone name given: " + this._tz + ".  For a list of acceptable names, use listTimezone().");
        }
        new MRTask(){

            @Override
            public void setupLocal() {
                ParseTime.setTimezone(ASTSetTimeZone.this._tz);
            }
        }.doAllNodes();
    }
}

