/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.AST;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValNum;

class ASTSignif
extends ASTUniPrefixOp {
    int _digits = 6;

    @Override
    String opStr() {
        return "signif";
    }

    ASTSignif() {
        super(new String[]{"signif", "x", "digits"});
    }

    @Override
    ASTSignif parse_impl(Exec E) {
        AST ary = E.parse();
        try {
            this._digits = (int)((ASTNum)E.parse()).dbl();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Expected a double for `digits` argument.");
        }
        E.eatEnd();
        ASTSignif res = (ASTSignif)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    ASTOp make() {
        return new ASTSignif();
    }

    @Override
    void apply(Env env) {
        final int digits = this._digits;
        if (digits < 0) {
            throw new IllegalArgumentException("Error in signif: argument digits must be a non-negative integer");
        }
        if (env.isAry()) {
            Frame fr = env.popAry();
            for (int i = 0; i < fr.vecs().length; ++i) {
                if (!fr.vecs()[i].isEnum()) continue;
                throw new IllegalArgumentException("Non-numeric column " + String.valueOf(i + 1) + " in data frame");
            }
            Frame fr2 = ((MRTask)new MRTask(){

                @Override
                public void map(Chunk[] chks, NewChunk[] nchks) {
                    for (int i = 0; i < nchks.length; ++i) {
                        NewChunk n = nchks[i];
                        Chunk c = chks[i];
                        int rlen = c._len;
                        for (int r = 0; r < rlen; ++r) {
                            n.addNum(ASTSignif.signifDigits(c.atd(r), digits));
                        }
                    }
                }
            }.doAll(fr.numCols(), fr)).outputFrame(fr.names(), fr.domains());
            env.pushAry(fr2);
        } else {
            env.push(new ValNum(ASTSignif.signifDigits(env.popDbl(), digits)));
        }
    }

    static double signifDigits(double x, int digits) {
        if (Double.isNaN(x)) {
            return x;
        }
        BigDecimal bd = new BigDecimal(x);
        bd = bd.round(new MathContext(digits, RoundingMode.HALF_EVEN));
        return bd.doubleValue();
    }
}

