/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Iterator;
import water.H2O;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.ValueString;
import water.rapids.AST;
import water.rapids.ASTDoubleList;
import water.rapids.ASTGroupBy;
import water.rapids.ASTLongList;
import water.rapids.ASTNull;
import water.rapids.ASTSeries;
import water.rapids.ASTSpan;
import water.rapids.ASTStringList;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValNum;
import water.rapids.ValSeries;
import water.rapids.ValSpan;
import water.rapids.ValStr;
import water.rapids.ValStringList;
import water.util.IcedInt;

class ASTSlice
extends AST {
    @Override
    ASTSlice make() {
        return new ASTSlice();
    }

    @Override
    String opStr() {
        return "[";
    }

    ASTSlice() {
    }

    @Override
    ASTSlice parse_impl(Exec E) {
        AST fr = E.parse();
        AST rows = E.parse();
        switch (rows.type()) {
            case 2: {
                rows = new ASTNull();
                break;
            }
            case 5: {
                rows = ((ASTSpan)rows).setSlice(true, false);
                break;
            }
            case 6: {
                rows = ((ASTSeries)rows).setSlice(true, false);
                break;
            }
            case 9: {
                rows = new ASTSeries(((ASTLongList)rows)._l, null, ((ASTLongList)rows)._spans);
                ((ASTSeries)rows).setSlice(true, false);
                break;
            }
            case 99999: {
                rows = new ASTNull();
                break;
            }
        }
        if (!E.hasNext()) {
            throw new IllegalArgumentException("Slice expected 3 arguments (frame, rows, cols), but got 2");
        }
        AST cols = E.parse();
        if (!(cols instanceof ASTStringList)) {
            switch (cols.type()) {
                case 2: {
                    cols = cols.value().equals("null") ? new ASTNull() : cols;
                    break;
                }
                case 5: {
                    cols = ((ASTSpan)cols).setSlice(false, true);
                    break;
                }
                case 6: {
                    cols = ((ASTSeries)cols).setSlice(false, true);
                    break;
                }
                case 9: {
                    if (cols instanceof ASTLongList) {
                        cols = new ASTSeries(((ASTLongList)cols)._l, null, ((ASTLongList)cols)._spans);
                    } else {
                        double[] d = ((ASTDoubleList)cols)._d;
                        long[] l = new long[d.length];
                        int i = 0;
                        for (double dd : d) {
                            l[i++] = (long)dd;
                        }
                        cols = new ASTSeries(l, null, ((ASTDoubleList)cols)._spans);
                    }
                    ((ASTSeries)cols).setSlice(false, true);
                    break;
                }
                case 99999: {
                    cols = new ASTNull();
                    break;
                }
            }
        }
        E.eatEnd();
        ASTSlice res = (ASTSlice)this.clone();
        res._asts = new AST[]{fr, rows, cols};
        return res;
    }

    @Override
    String value() {
        return null;
    }

    @Override
    int type() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void exec(Env env) {
        int cols_type = env.peekType();
        Val cols = env.pop();
        int rows_type = env.peekType();
        Val rows = env.pop();
        if (cols_type == 9) {
            assert (cols instanceof ValStringList) : "Expected ValStringList. Got: " + cols.getClass();
            String[] colnames = ((ValStringList)cols)._s;
            long[] colz = new long[colnames.length];
            for (int i = 0; i < colz.length; ++i) {
                colz[i] = env.peekAry().find(colnames[i]);
            }
            cols = new ValSeries(colz, null);
            ((ValSeries)cols).setSlice(false, true);
        }
        if (cols_type == 2) {
            Frame ary = env.peekAry();
            int idx = ary.find(((ValStr)cols)._s);
            if (idx == -1) {
                throw new IllegalArgumentException("Column name not in frame, " + cols);
            }
            cols = new ValNum(idx);
            cols_type = 3;
        }
        if (cols_type == 3 && rows_type == 3) {
            long row = (long)((ValNum)rows)._d;
            int col = (int)((ValNum)cols)._d;
            Frame ary = env.isNum() ? new Frame(Vec.makeCon(env.popDbl(), 1L)) : env.popAry();
            try {
                if (ary.vecs()[col].isEnum()) {
                    env.push(new ValStr(ary.vecs()[col].domain()[(int)ary.vecs()[col].at(row)]));
                    return;
                }
                if (ary.vecs()[col].isString()) {
                    env.push(new ValStr(ary.vecs()[col].atStr(new ValueString(), row).toString()));
                    return;
                }
                env.push(new ValNum(ary.vecs()[col].at(row)));
                return;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (col < 0) {
                    int rm_col = -1 * col - 1;
                    long[] columns = new long[ary.numCols() - 1];
                    int v = 0;
                    for (int i = 0; i < columns.length; ++i) {
                        if (i == rm_col) {
                            // empty if block
                        }
                        int n = ++v;
                        ++v;
                        columns[i] = n;
                    }
                    ValSeries vs = new ValSeries(columns, null);
                    vs.setSlice(false, true);
                    env.pushAry(ary);
                    env.push(rows);
                    env.push(vs);
                    this.exec(env);
                    return;
                }
                if (row >= 0L && row < ary.vecs()[col].length()) return;
                throw new IllegalArgumentException("Row index out of bounds: tried to select row 0<=" + row + "<=" + (ary.vecs()[col].length() - 1L) + ".");
            }
        } else {
            Frame fr2;
            Frame ary = env.peekAry();
            if (rows_type == 1) {
                env.addRef(((ValFrame)rows)._fr);
            }
            Object colSelect = ASTSlice.select(ary.numCols(), cols, env, true);
            Object rowSelect = ASTSlice.select(ary.numRows(), rows, env, false);
            if (rowSelect == null && (colSelect == null || colSelect instanceof long[])) {
                if (colSelect == null) {
                    fr2 = ary;
                } else {
                    long[] cols2 = (long[])colSelect;
                    if (cols2.length > 0 && cols2[0] < 0L) {
                        int[] idxs = new int[cols2.length];
                        fr2 = new Frame(ary);
                        for (int i = 0; i < cols2.length; ++i) {
                            idxs[i] = (int)(-cols2[i]) - 1;
                        }
                        fr2.remove(idxs);
                    } else {
                        fr2 = new Frame(new Vec[0]);
                        for (long aCols2 : cols2) {
                            fr2.add(ary._names[(int)aCols2], ary.vec((int)aCols2));
                        }
                    }
                }
            } else {
                fr2 = ary.deepSlice(rowSelect, colSelect);
                if (colSelect instanceof Frame && cols_type != 1) {
                    for (Vec v : ((Frame)colSelect).vecs()) {
                        Keyed.remove(v._key);
                    }
                }
                if (rowSelect instanceof Frame && rows_type != 1) {
                    for (Vec v : ((Frame)rowSelect).vecs()) {
                        Keyed.remove(v._key);
                    }
                }
                if (fr2 == null) {
                    fr2 = new Frame(new Vec[0]);
                }
                if (rows_type == 1) {
                    env.subRef(((ValFrame)rows)._fr);
                }
            }
            env.poppush(1, new ValFrame(fr2));
        }
    }

    static Object select(final long len, Val v, Env env, boolean isCol) {
        long[] cols;
        if (v.type() == 99999) {
            return null;
        }
        env.push(v);
        if (env.isNum()) {
            int col = (int)env.popDbl();
            if (col < 0 && (long)col < -len) {
                col = 0;
            }
            if (col < 0) {
                ValSeries s = new ValSeries(new long[]{col}, null);
                s.setSlice(!isCol, isCol);
                return ASTSlice.select(len, s, env, isCol);
            }
            return new long[]{col};
        }
        if (env.isSeries()) {
            ValSeries a = env.popSeries();
            if (!a.isValid()) {
                throw new IllegalArgumentException("Cannot mix negative and positive array selection.");
            }
            if (a.isColSelector()) {
                return a.toArray();
            }
            if (a.isNum() && !a.all_neg()) {
                return ASTSlice.select(len, new ValNum(a.toNum()), env, isCol);
            }
            Frame ary = env.peekAry();
            Vec v0 = a.all_neg() ? ary.anyVec().makeCon(1.0) : ary.anyVec().makeZero();
            final ValSeries a0 = a;
            Frame fr = a0.all_neg() ? ((MRTask)((MRTask)new MRTask(){

                @Override
                public void map(Chunk cs) {
                    for (long i = cs.start(); i < (long)cs._len + cs.start(); ++i) {
                        if (!a0.contains(-i)) continue;
                        cs.set((int)(i - cs.start()), 0L);
                    }
                }
            }.doAll((Vec[])new Vec[]{v0})).getResult())._fr : ((MRTask)((MRTask)new MRTask(){

                @Override
                public void map(Chunk cs) {
                    for (long i = cs.start(); i < (long)cs._len + cs.start(); ++i) {
                        if (!a0.contains(i)) continue;
                        cs.set((int)(i - cs.start()), i + 1L);
                    }
                }
            }.doAll((Vec[])new Vec[]{v0})).getResult())._fr;
            return fr;
        }
        if (env.isSpan()) {
            ValSpan a = env.popSpan();
            if (Double.isNaN(a._max) || a._max > (double)len) {
                a._max = Math.max(0L, len - 1L);
            }
            if (!a.isValid()) {
                throw new IllegalArgumentException("Cannot mix negative and positive array selection.");
            }
            if (a.isColSelector()) {
                return a.toArray();
            }
            Frame ary = env.peekAry();
            final ValSpan a0 = a;
            Vec v0 = a.all_neg() ? ary.anyVec().makeCon(1.0) : ary.anyVec().makeZero();
            Frame fr = a0.all_neg() ? ((MRTask)((MRTask)new MRTask(){

                @Override
                public void map(Chunk cs) {
                    for (long i = cs.start(); i < (long)cs._len + cs.start(); ++i) {
                        if (!a0.contains(-i)) continue;
                        cs.set((int)(i - cs.start() - 1L), 0L);
                    }
                }
            }.doAll((Vec[])new Vec[]{v0})).getResult())._fr : ((MRTask)((MRTask)new MRTask(){

                @Override
                public void map(Chunk cs) {
                    for (long i = cs.start(); i < (long)cs._len + cs.start(); ++i) {
                        if (!a0.contains(i)) continue;
                        cs.set((int)(i - cs.start()), i + 1L);
                    }
                }
            }.doAll((Vec[])new Vec[]{v0})).getResult())._fr;
            return fr;
        }
        Frame ary = env.popAry();
        if (ary.numCols() != 1) {
            throw new IllegalArgumentException("Selector must be a single column: " + ASTSlice.AtoS(ary.names()));
        }
        Vec vec = ary.anyVec();
        if (isCol) {
            if (vec.min() != 0.0 && vec.max() != 1.0 && !vec.isInt()) {
                throw new IllegalArgumentException("Vec selector must be a single columns of 1s and 0s.");
            }
            final ASTGroupBy.IcedNBHS hs = new ASTGroupBy.IcedNBHS();
            new MRTask(){

                @Override
                public void map(Chunk c) {
                    int start = (int)c.start();
                    for (int i = 0; i < c._len; ++i) {
                        if (c.at8(i) != 1L || len <= (long)(i + start)) continue;
                        hs.add(new IcedInt(start + i));
                    }
                }
            }.doAll(ary);
            cols = new long[(int)Math.min((long)hs.size(), len)];
            Iterator it = hs.iterator();
            int j = 0;
            while (j < cols.length && it.hasNext()) {
                cols[j++] = ((IcedInt)it.next())._val;
            }
        } else {
            if (ary.numRows() == len && vec.min() >= 0.0 && vec.max() <= 1.0 && vec.isInt()) {
                return ary;
            }
            if (ary.numRows() > 10000000L) {
                throw H2O.fail("Unimplemented: Cannot explicitly select > 10000000 rows in slice.");
            }
            cols = MemoryManager.malloc8((int)ary.numRows());
            for (int i = 0; i < cols.length; ++i) {
                if (vec.isNA(i)) {
                    throw new IllegalArgumentException("Can not use NA as index!");
                }
                cols[i] = vec.at8(i);
            }
        }
        return cols;
    }

    private static String AtoS(String[] s) {
        StringBuilder sb = new StringBuilder();
        for (String ss : s) {
            sb.append(ss).append(',');
        }
        return sb.toString();
    }

    public String toString() {
        return "[,]";
    }

    @Override
    public StringBuilder toString(StringBuilder sb, int d) {
        this.indent(sb, d).append(this).append('\n');
        this._asts[0].toString(sb, d + 1).append("\n");
        if (this._asts[2] == null) {
            this.indent(sb, d + 1).append("all\n");
        } else {
            this._asts[2].toString(sb, d + 1).append("\n");
        }
        if (this._asts[1] == null) {
            this.indent(sb, d + 1).append("all");
        } else {
            this._asts[1].toString(sb, d + 1);
        }
        return sb;
    }
}

