/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Locale;
import water.DKV;
import water.fvec.Frame;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;

class ASTToLower
extends ASTUniPrefixOp {
    ASTToLower() {
    }

    @Override
    String opStr() {
        return "tolower";
    }

    @Override
    ASTOp make() {
        return new ASTToLower();
    }

    @Override
    void apply(Env env) {
        if (!env.isAry()) {
            throw new IllegalArgumentException("tolower only operates on a single vector!");
        }
        Frame fr = env.popAry();
        if (fr.numCols() != 1) {
            throw new IllegalArgumentException("tolower only takes a single column of data. Got " + fr.numCols() + " columns.");
        }
        String[] dom = fr.anyVec().domain();
        for (int i = 0; i < dom.length; ++i) {
            dom[i] = dom[i].toLowerCase(Locale.ENGLISH);
        }
        fr.anyVec().setDomain(dom);
        if (fr._key != null && DKV.getGet(fr._key) != null) {
            DKV.put(fr._key, fr);
        }
        env.pushAry(fr);
    }
}

