/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.fvec.Frame;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;

class ASTTrim
extends ASTUniPrefixOp {
    ASTTrim() {
        super(new String[]{"trim", "x"});
    }

    @Override
    String opStr() {
        return "trim";
    }

    @Override
    ASTOp make() {
        return new ASTTrim();
    }

    @Override
    void apply(Env env) {
        Frame fr = env.popAry();
        if (fr.numCols() != 1) {
            throw new IllegalArgumentException("trim works on a single column at a time.");
        }
        if (!fr.anyVec().isEnum()) {
            throw new IllegalArgumentException("column must be character.");
        }
        String[] doms = fr.anyVec().domain();
        for (int i = 0; i < doms.length; ++i) {
            doms[i] = doms[i].trim();
        }
        fr.anyVec().setDomain(doms);
        if (fr._key != null && DKV.getGet(fr._key) != null) {
            DKV.put(fr._key, fr);
        }
        env.pushAry(fr);
    }
}

