/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.ASTGroupBy;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.util.IcedHashMap;

class ASTUnique
extends ASTUniPrefixOp {
    @Override
    String opStr() {
        return "unique";
    }

    @Override
    ASTOp make() {
        return new ASTUnique();
    }

    public ASTUnique() {
        super(new String[]{"x"});
    }

    @Override
    public void apply(Env e) {
        Vec v;
        Frame f = e.popAry();
        if (f.numCols() != 1) {
            throw new IllegalArgumentException("Must give a single numeric column.");
        }
        if (f.anyVec().isEnum()) {
            v = Vec.makeSeq(0L, f.anyVec().domain().length, true);
            v.setDomain(f.anyVec().domain());
            DKV.put(v);
        } else {
            UniqTask t = (UniqTask)new UniqTask().doAll(f);
            int nUniq = t._uniq.size();
            final ASTGroupBy.G[] uniq = t._uniq.keySet().toArray(new ASTGroupBy.G[nUniq]);
            v = Vec.makeZero(nUniq);
            new MRTask(){

                @Override
                public void map(Chunk c) {
                    int start = (int)c.start();
                    for (int i = 0; i < c._len; ++i) {
                        c.set(i, uniq[i + start]._ds[0]);
                    }
                }
            }.doAll(v);
        }
        e.pushAry(new Frame(v));
    }

    private static class UniqTask
    extends MRTask<UniqTask> {
        IcedHashMap<ASTGroupBy.G, String> _uniq;

        private UniqTask() {
        }

        @Override
        public void map(Chunk[] c) {
            this._uniq = new IcedHashMap();
            ASTGroupBy.G g = new ASTGroupBy.G(1);
            for (int i = 0; i < c[0]._len; ++i) {
                g.fill(i, c, new long[]{0L});
                String s_old = this._uniq.putIfAbsent(g, "");
                if (s_old != null) continue;
                g = new ASTGroupBy.G(1);
            }
        }

        @Override
        public void reduce(UniqTask t) {
            if (this._uniq != t._uniq) {
                IcedHashMap<ASTGroupBy.G, String> l = this._uniq;
                IcedHashMap<ASTGroupBy.G, String> r = t._uniq;
                if (l.size() < r.size()) {
                    l = r;
                    r = this._uniq;
                }
                for (ASTGroupBy.G rg : r.keySet()) {
                    l.putIfAbsent(rg, "");
                }
                this._uniq = l;
                t._uniq = null;
            }
        }
    }
}

