/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.Futures;
import water.Key;
import water.MRTask;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTId;
import water.rapids.ASTMean;
import water.rapids.ASTNull;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTString;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValFrame;
import water.rapids.ValNum;
import water.rapids.ValStr;

class ASTVar
extends ASTUniPrefixOp {
    boolean _narm = false;
    boolean _ynull = false;

    public ASTVar() {
        super(new String[]{"var", "ary", "y", "na.rm", "use"});
    }

    @Override
    String opStr() {
        return "var";
    }

    @Override
    ASTOp make() {
        return new ASTVar();
    }

    @Override
    ASTVar parse_impl(Exec E) {
        ASTString use;
        AST ary = E.parse();
        AST y = E.parse();
        if (y instanceof ASTNull) {
            this._ynull = true;
            y = ary;
        }
        AST a = E._env.lookup((ASTId)E.parse());
        try {
            this._narm = ((ASTNum)a).dbl() == 1.0;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Argument `na.rm` expected to be a number.");
        }
        AST u = E.parse();
        if (u instanceof ASTNull) {
            use = new ASTString('\"', "null");
        } else if (u instanceof ASTString) {
            use = (ASTString)u;
        } else {
            throw new IllegalArgumentException("Argument `use` expected to be a string.");
        }
        E.eatEnd();
        ASTVar res = (ASTVar)this.clone();
        res._asts = new AST[]{use, y, ary};
        return res;
    }

    @Override
    void apply(Env env) {
        if (env.isNum()) {
            env.pop();
            env.push(new ValNum(Double.NaN));
        } else {
            String use;
            Frame y;
            Frame fr = env.peekAry();
            if (env.isEmpty() || env.sp() <= 1) {
                y = fr;
                use = "everything";
            } else {
                y = ((ValFrame)env.peekAt((int)-1))._fr;
                use = env.isEmpty() || env.sp() <= 1 ? "everything" : ((ValStr)env.peekAt((int)-2))._s;
            }
            String[] colnames = y.names();
            if (fr.numRows() != y.numRows()) {
                throw new IllegalArgumentException("In var(): incompatible dimensions. Frames must have the same number of rows.");
            }
            if (use.equals("everything")) {
                this._narm = false;
            }
            if (use.equals("complete.obs")) {
                this._narm = true;
            }
            if (use.equals("all.obs")) {
                this._narm = false;
            }
            if (fr.numRows() == 1L) {
                double xmean = 0.0;
                double ymean = 0.0;
                double divideby = fr.numCols() - 1;
                double ss = 0.0;
                for (Vec v : fr.vecs()) {
                    xmean += v.at(0L);
                }
                for (Vec v : y.vecs()) {
                    ymean += v.at(0L);
                }
                if (Double.isNaN(xmean /= divideby + 1.0) || Double.isNaN(ymean /= divideby + 1.0)) {
                    ss = Double.NaN;
                } else {
                    int r = 0;
                    while ((double)r <= divideby) {
                        ss += (fr.vecs()[r].at(0L) - xmean) * (y.vecs()[r].at(0L) - ymean);
                        ++r;
                    }
                }
                env.poppush(3, new ValNum(Double.isNaN(ss) ? ss : ss / divideby));
            } else {
                int r;
                int c;
                double[][] covars = new double[y.numCols()][fr.numCols()];
                CovarTask[][] tsks = new CovarTask[y.numCols()][fr.numCols()];
                Frame[][] frs = new Frame[y.numCols()][fr.numCols()];
                double[] xmeans = new double[fr.numCols()];
                double[] ymeans = new double[y.numCols()];
                for (int r2 = 0; r2 < fr.numCols(); ++r2) {
                    xmeans[r2] = ASTVar.getMean(fr.vecs()[r2], this._narm, use);
                }
                for (c = 0; c < y.numCols(); ++c) {
                    ymeans[c] = ASTVar.getMean(y.vecs()[c], this._narm, use);
                }
                for (c = 0; c < y.numCols(); ++c) {
                    for (r = 0; r < fr.numCols(); ++r) {
                        frs[c][r] = new Frame(y.vecs()[c], fr.vecs()[r]);
                        tsks[c][r] = (CovarTask)new CovarTask(ymeans[c], xmeans[r]).doAll(frs[c][r]);
                    }
                }
                for (c = 0; c < y.numCols(); ++c) {
                    for (r = 0; r < fr.numCols(); ++r) {
                        covars[c][r] = ((CovarTask)tsks[c][r].getResult())._ss / (double)(fr.numRows() - 1L);
                        frs[c][r] = null;
                    }
                }
                if (covars.length == 1 && covars[0].length == 1) {
                    env.poppush(3, new ValNum(covars[0][0]));
                } else {
                    Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(covars.length);
                    Vec[] vecs = new Vec[covars.length];
                    Futures fs = new Futures();
                    for (int i = 0; i < covars.length; ++i) {
                        AppendableVec v = new AppendableVec((Key)keys[i]);
                        NewChunk c2 = new NewChunk(v, 0);
                        for (int j = 0; j < covars[0].length; ++j) {
                            c2.addNum(covars[i][j]);
                        }
                        c2.close(0, fs);
                        vecs[i] = v.close(fs);
                    }
                    fs.blockForPending();
                    env.poppush(3, new ValFrame(new Frame(colnames, vecs)));
                }
            }
        }
    }

    static double getMean(Vec v, boolean narm, String use) {
        ASTMean.MeanNARMTask t = (ASTMean.MeanNARMTask)new ASTMean.MeanNARMTask(narm).doAll(v);
        if (t._rowcnt == 0L || Double.isNaN(t._sum)) {
            if (use.equals("all.obs")) {
                throw new IllegalArgumentException("use = \"all.obs\" with missing observations.");
            }
            return Double.NaN;
        }
        return t._sum / (double)t._rowcnt;
    }

    static double getVar(Vec v, boolean narm) {
        double m = ASTVar.getMean(v, narm, "");
        CovarTask t = (CovarTask)new CovarTask(m, m).doAll(new Frame(v, v));
        return t._ss / (double)(v.length() - 1L);
    }

    static class CovarTask
    extends MRTask<CovarTask> {
        double _ss;
        double _xmean;
        double _ymean;

        CovarTask(double xmean, double ymean) {
            this._xmean = xmean;
            this._ymean = ymean;
        }

        @Override
        public void map(Chunk[] cs) {
            int len = cs[0]._len;
            Chunk x = cs[0];
            Chunk y = cs[1];
            if (Double.isNaN(this._xmean) || Double.isNaN(this._ymean)) {
                this._ss = Double.NaN;
                return;
            }
            for (int r = 0; r < len; ++r) {
                this._ss += (x.atd(r) - this._xmean) * (y.atd(r) - this._ymean);
            }
        }

        @Override
        public void reduce(CovarTask tsk) {
            this._ss += tsk._ss;
        }
    }
}

