/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import water.Futures;
import water.Key;
import water.MRTask;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTWhich
extends ASTUniPrefixOp {
    int _one_based;

    ASTWhich() {
        super(null);
    }

    @Override
    String opStr() {
        return "h2o.which";
    }

    @Override
    ASTWhich make() {
        return new ASTWhich();
    }

    @Override
    ASTWhich parse_impl(Exec E) {
        AST condition = E.parse();
        AST a = E.parse();
        if (a instanceof ASTId) {
            this._one_based = (int)((ASTNum)E._env.lookup((ASTId)((ASTId)a)))._d;
        }
        ASTWhich res = (ASTWhich)this.clone();
        res._asts = new AST[]{condition};
        return res;
    }

    @Override
    public void apply(Env e) {
        Frame f = e.popAry();
        if (f.numRows() == 1L && f.numCols() > 1) {
            double[] in = new double[f.numCols()];
            for (int i = 0; i < in.length; ++i) {
                in[i] = f.vecs()[i].at(0L);
            }
            double[] out = this.map(null, in, null, null);
            Futures fs = new Futures();
            Key<Vec> key = Vec.VectorGroup.VG_LEN1.addVecs(1)[0];
            AppendableVec v = new AppendableVec((Key)key);
            NewChunk chunk = new NewChunk(v, 0);
            for (double d : out) {
                chunk.addNum(d);
            }
            chunk.close(0, fs);
            Vec vec = v.close(fs);
            fs.blockForPending();
            Frame fr2 = new Frame(vec);
            e.pushAry(fr2);
            return;
        }
        Frame f2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk nc) {
                long start = c.start();
                for (int i = 0; i < c._len; ++i) {
                    if (c.at8(i) != 1L) continue;
                    nc.addNum((long)ASTWhich.this._one_based + start + (long)i);
                }
            }
        }.doAll(1, f.anyVec())).outputFrame();
        e.pushAry(f2);
    }

    @Override
    double[] map(Env env, double[] in, double[] out, AST[] args) {
        int i;
        ArrayList<Integer> w = new ArrayList<Integer>();
        for (i = 0; i < in.length; ++i) {
            if (in[i] != 1.0) continue;
            w.add(i + this._one_based);
        }
        out = new double[w.size()];
        for (i = 0; i < w.size(); ++i) {
            out[i] = ((Integer)w.get(i)).intValue();
        }
        return out;
    }
}

