/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTReducerOp;
import water.rapids.Env;

class ASTXorSum
extends ASTReducerOp {
    ASTXorSum() {
        super(0.0);
    }

    @Override
    String opStr() {
        return "xorsum";
    }

    @Override
    ASTOp make() {
        return new ASTXorSum();
    }

    @Override
    double op(double d0, double d1) {
        long d0Bits = Double.doubleToLongBits(d0);
        long d1Bits = Double.doubleToLongBits(d1);
        long xorsumBits = d0Bits ^ d1Bits;
        long ZERO_SOME_SIGN_EXP = 0xFFFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(xorsumBits &= 0xFFFFFFFFFFFFFFFL);
    }

    @Override
    double[] map(Env env, double[] in, double[] out, AST[] args) {
        if (out == null || out.length < 1) {
            out = new double[1];
        }
        long xorsumBits = 0L;
        double xorsum = 0.0;
        for (double v : in) {
            long vBits = Double.doubleToLongBits(v);
            xorsumBits ^= vBits;
        }
        long ZERO_SOME_SIGN_EXP = 0xFFFFFFFFFFFFFFFL;
        out[0] = xorsum = Double.longBitsToDouble(xorsumBits &= 0xFFFFFFFFFFFFFFFL);
        return out;
    }
}

