/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import water.rapids.ASTSpan;
import water.rapids.Val;

class ValSeries
extends Val {
    final long[] _idxs;
    final ASTSpan[] _spans;
    final double[] _d;
    boolean _isCol;
    boolean _isRow;
    int[] _order;

    ValSeries(long[] idxs, ASTSpan[] spans) {
        this._idxs = idxs;
        this._d = null;
        if (this._idxs != null) {
            Arrays.sort(this._idxs);
        }
        this._spans = spans;
    }

    ValSeries(long[] idxs, double[] d, ASTSpan[] spans) {
        this._idxs = idxs;
        this._d = d;
        if (this._idxs != null) {
            Arrays.sort(this._idxs);
        }
        this._spans = spans;
    }

    boolean contains(long a) {
        if (this._spans != null) {
            for (ASTSpan s : this._spans) {
                if (!s.contains(a)) continue;
                return true;
            }
        }
        return this._idxs != null && Arrays.binarySearch(this._idxs, a) >= 0;
    }

    boolean isColSelector() {
        return this._isCol;
    }

    boolean isRowSelector() {
        return this._isRow;
    }

    void setSlice(boolean row, boolean col) {
        this._isRow = row;
        this._isCol = col;
    }

    @Override
    String value() {
        return null;
    }

    @Override
    int type() {
        return 6;
    }

    public String toString() {
        String res = "c(";
        if (this._spans != null) {
            for (ASTSpan s : this._spans) {
                res = res + s.toString();
                res = res + ",";
            }
            if (this._idxs == null) {
                res = res.substring(0, res.length() - 1);
            }
        }
        if (this._idxs != null) {
            if (this._idxs.length > 20) {
                res = res + "many ";
            } else {
                for (long l : this._idxs) {
                    res = res + l;
                    res = res + ",";
                }
            }
            res = res.substring(0, res.length() - 1);
        }
        res = res + ")";
        return res;
    }

    long[] toArray() {
        int res_length = 0;
        if (this._spans != null) {
            for (ASTSpan s : this._spans) {
                res_length += Math.abs((int)s._max) - Math.abs((int)s._min) + 1;
            }
        }
        if (this._idxs != null) {
            res_length += this._idxs.length;
        }
        long[] res = new long[res_length];
        int cur = 0;
        if (this._spans != null) {
            ASTSpan[] arr$ = this._spans;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                long[] l;
                ASTSpan s = arr$[i$];
                for (long aL : l = s.toArray()) {
                    res[cur++] = aL;
                }
            }
        }
        if (this._idxs != null) {
            for (long _idx : this._idxs) {
                res[cur++] = _idx;
            }
        }
        Arrays.sort(res);
        if (this.all_neg()) {
            ValSeries.reverse(res);
        }
        return res;
    }

    private static void reverse(long[] r) {
        Long[] l = new Long[r.length];
        for (int i = 0; i < l.length; ++i) {
            l[i] = r[i];
        }
        List<Long> list = Arrays.asList(l);
        Collections.reverse(list);
        for (int i = 0; i < list.size(); ++i) {
            r[i] = list.get(i);
        }
    }

    boolean isValid() {
        return true;
    }

    boolean isNum() {
        boolean ret = false;
        if (this._idxs != null && this._idxs.length > 0 && this._idxs.length == 1) {
            ret = true;
        }
        if (this._spans != null && this._spans.length > 0) {
            for (ASTSpan s : this._spans) {
                ret &= s.isNum();
            }
        }
        return ret;
    }

    long toNum() {
        if (this._idxs != null && this._idxs.length > 0) {
            return this._idxs[0];
        }
        if (this._spans != null && this._spans.length > 0) {
            return this._spans[0].toNum();
        }
        throw new IllegalArgumentException("Could not convert ASTSeries to a single number.");
    }

    boolean all_neg() {
        return this._idxs != null && this._idxs.length > 0 ? this._idxs[0] < 0L : this._spans[0].all_neg();
    }

    boolean all_pos() {
        return !this.all_neg();
    }
}

