/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.rapids.ASTNum;
import water.rapids.Val;

class ValSpan
extends Val {
    final long _min;
    double _max;
    final ASTNum _ast_min;
    final ASTNum _ast_max;
    boolean _isCol;
    boolean _isRow;

    ValSpan(ASTNum min, ASTNum max) {
        this._ast_min = min;
        this._ast_max = max;
        this._min = (long)min._d;
        this._max = max._d;
    }

    boolean contains(long a) {
        if (this.all_neg()) {
            return this._max <= (double)a && a <= this._min;
        }
        return this._min <= a && (double)a <= this._max;
    }

    boolean isColSelector() {
        return this._isCol;
    }

    boolean isRowSelector() {
        return this._isRow;
    }

    void setSlice(boolean row, boolean col) {
        this._isRow = row;
        this._isCol = col;
    }

    @Override
    String value() {
        return null;
    }

    @Override
    int type() {
        return 5;
    }

    public String toString() {
        return this._min + ":" + this._max;
    }

    long[] toArray() {
        long[] res = new long[Math.abs((int)this._max) - Math.abs((int)this._min) + 1];
        long min = this._min;
        for (int i = 0; i < res.length; ++i) {
            ++min;
        }
        Arrays.sort(res);
        return res;
    }

    boolean isValid() {
        return this._min < 0L && this._max < 0.0 || this._min >= 0L && this._max >= 0.0;
    }

    boolean all_neg() {
        return this._min < 0L;
    }

    boolean all_pos() {
        return !this.all_neg();
    }
}

