/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import water.Key;

public class FileUtils {
    public static void close(Closeable ... closeable) {
        for (Closeable c : closeable) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException xe) {
                // empty catch block
            }
        }
    }

    public static void copyStream(InputStream is, OutputStream os, int buffer_size) {
        try {
            int count;
            byte[] bytes = new byte[buffer_size];
            while ((count = is.read(bytes, 0, buffer_size)) > 0) {
                os.write(bytes, 0, count);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URI getURI(String path) {
        if (path.contains(":/")) {
            return URI.create(path);
        }
        return new File(path).toURI();
    }

    public static boolean delete(File file) {
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                f.delete();
            }
            return file.delete();
        }
        return false;
    }

    public static String keyToFileName(Key k) {
        return k.toString().replaceAll("[^a-zA-Z0-9_\\-\\.]", "_");
    }
}

