/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.concurrent.TimeUnit;

public class PrettyPrint {
    static final String[] SCALE = new String[]{"N/A", "%4.0f  B", "%.1f KB", "%.1f MB", "%.2f GB", "%.3f TB", "%.3f PB"};
    static double[] powers10 = new double[]{1.0E-10, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10};
    public static long[] powers10i = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public static String msecs(long msecs, boolean truncate) {
        long hr = TimeUnit.MILLISECONDS.toHours(msecs);
        long min = TimeUnit.MILLISECONDS.toMinutes(msecs -= TimeUnit.HOURS.toMillis(hr));
        long sec = TimeUnit.MILLISECONDS.toSeconds(msecs -= TimeUnit.MINUTES.toMillis(min));
        long ms = TimeUnit.MILLISECONDS.toMillis(msecs -= TimeUnit.SECONDS.toMillis(sec));
        if (!truncate) {
            return String.format("%02d:%02d:%02d.%03d", hr, min, sec, ms);
        }
        if (hr != 0L) {
            return String.format("%2d:%02d:%02d.%03d", hr, min, sec, ms);
        }
        if (min != 0L) {
            return String.format("%2d min %2d.%03d sec", min, sec, ms);
        }
        return String.format("%2d.%03d sec", sec, ms);
    }

    public static String usecs(long usecs) {
        long hr = TimeUnit.MICROSECONDS.toHours(usecs);
        long min = TimeUnit.MICROSECONDS.toMinutes(usecs -= TimeUnit.HOURS.toMicros(hr));
        long sec = TimeUnit.MICROSECONDS.toSeconds(usecs -= TimeUnit.MINUTES.toMicros(min));
        long ms = TimeUnit.MICROSECONDS.toMillis(usecs -= TimeUnit.SECONDS.toMicros(sec));
        usecs -= TimeUnit.MILLISECONDS.toMicros(ms);
        if (hr != 0L) {
            return String.format("%2d:%02d:%02d.%03d", hr, min, sec, ms);
        }
        if (min != 0L) {
            return String.format("%2d min %2d.%03d sec", min, sec, ms);
        }
        if (sec != 0L) {
            return String.format("%2d.%03d sec", sec, ms);
        }
        if (ms != 0L) {
            return String.format("%3d.%03d msec", ms, usecs);
        }
        return String.format("%3d usec", usecs);
    }

    static int byteScale(long bytes) {
        for (int i = 0; i < 6; ++i) {
            if (bytes >= 1L << i * 10) continue;
            return i;
        }
        return 6;
    }

    static double bytesScaled(long bytes, int scale) {
        if (scale == 0) {
            return bytes;
        }
        return (double)bytes / (double)(1L << (scale - 1) * 10);
    }

    public static String bytes(long bytes) {
        return PrettyPrint.bytes(bytes, PrettyPrint.byteScale(bytes));
    }

    static String bytes(long bytes, int scale) {
        return String.format(SCALE[scale], PrettyPrint.bytesScaled(bytes, scale));
    }

    public static String bytesPerSecond(long bytes) {
        if (bytes < 0L) {
            return "N/A";
        }
        return PrettyPrint.bytes(bytes) + "/S";
    }

    public static double pow10(int exp) {
        return exp >= -10 && exp <= 10 ? powers10[exp + 10] : Math.pow(10.0, exp);
    }

    public static long pow10i(int exp) {
        return exp > -1 && exp < 19 ? powers10i[exp] : (long)Math.pow(10.0, exp);
    }

    public static final boolean fitsIntoInt(double d) {
        return Math.abs((double)((int)d) - d) < 1.0E-8;
    }

    public static String UUID(long lo, long hi) {
        long lo0 = lo >> 32 & 0xFFFFFFFFL;
        long lo1 = lo >> 16 & 0xFFFFL;
        long lo2 = lo >> 0 & 0xFFFFL;
        long hi0 = hi >> 48 & 0xFFFFL;
        long hi1 = hi >> 0 & 0xFFFFFFFFFFFFL;
        return String.format("%08X-%04X-%04X-%04X-%012X", lo0, lo1, lo2, hi0, hi1);
    }

    public static String formatPct(double pct) {
        String s = "N/A";
        if (!Double.isNaN(pct)) {
            s = String.format("%5.2f %%", 100.0 * pct);
        }
        return s;
    }

    public static String withOrdinalIndicator(long i) {
        String ord;
        int d = (int)((double)Math.abs(i) / Math.pow(10.0, 1.0)) % 10;
        if (d == 1) {
            ord = "th";
        } else {
            d = (int)((double)Math.abs(i) / Math.pow(10.0, 0.0)) % 10;
            switch (d) {
                case 1: {
                    ord = "st";
                    break;
                }
                case 2: {
                    ord = "nd";
                    break;
                }
                case 3: {
                    ord = "rd";
                    break;
                }
                default: {
                    ord = "th";
                }
            }
        }
        return i + ord;
    }
}

