/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.exceptions.JCodeSB;
import water.util.IcedBitSet;

public final class SB
implements JCodeSB<SB> {
    public final StringBuilder _sb;
    int _indent = 0;
    public static final Pattern[] ILLEGAL_CHARACTERS = new Pattern[]{Pattern.compile("\\", 16), Pattern.compile("\"", 16)};
    public static final String[] REPLACEMENTS = new String[]{"\\\\\\\\", "\\\\\""};

    public SB() {
        this._sb = new StringBuilder();
    }

    public SB(String s) {
        this._sb = new StringBuilder(s);
    }

    @Override
    public SB ps(String s) {
        this._sb.append("\"");
        this.pj(s);
        this._sb.append("\"");
        return this;
    }

    @Override
    public SB p(String s) {
        this._sb.append(s);
        return this;
    }

    @Override
    public SB p(float s) {
        if (Float.isNaN(s)) {
            this._sb.append("Float.NaN");
        } else if (Float.isInfinite(s)) {
            this._sb.append(s > 0.0f ? "Float.POSITIVE_INFINITY" : "Float.NEGATIVE_INFINITY");
        } else {
            this._sb.append(s);
        }
        return this;
    }

    @Override
    public SB p(double s) {
        if (Double.isNaN(s)) {
            this._sb.append("Double.NaN");
        } else if (Double.isInfinite(s)) {
            this._sb.append(s > 0.0 ? "Double.POSITIVE_INFINITY" : "Double.NEGATIVE_INFINITY");
        } else {
            this._sb.append(s);
        }
        return this;
    }

    @Override
    public SB p(char s) {
        this._sb.append(s);
        return this;
    }

    @Override
    public SB p(int s) {
        this._sb.append(s);
        return this;
    }

    @Override
    public SB p(long s) {
        this._sb.append(s);
        return this;
    }

    @Override
    public SB p(boolean s) {
        this._sb.append(s);
        return this;
    }

    @Override
    public SB pobj(Object s) {
        this._sb.append(s.toString());
        return this;
    }

    @Override
    public SB i(int d) {
        for (int i = 0; i < d + this._indent; ++i) {
            this.p("  ");
        }
        return this;
    }

    @Override
    public SB i() {
        return this.i(0);
    }

    @Override
    public SB ip(String s) {
        return this.i().p(s);
    }

    @Override
    public SB s() {
        this._sb.append(' ');
        return this;
    }

    @Override
    public SB pj(double s) {
        if (Double.isInfinite(s)) {
            this._sb.append("Double.").append(s > 0.0 ? "POSITIVE_INFINITY" : "NEGATIVE_INFINITY");
        } else if (Double.isNaN(s)) {
            this._sb.append("Double.NaN");
        } else {
            this._sb.append(s);
        }
        return this;
    }

    @Override
    public SB pj(float s) {
        if (Float.isInfinite(s)) {
            this._sb.append("Float.").append(s > 0.0f ? "POSITIVE_INFINITY" : "NEGATIVE_INFINITY");
        } else if (Float.isNaN(s)) {
            this._sb.append("Float.NaN");
        } else {
            this._sb.append(s).append('f');
        }
        return this;
    }

    @Override
    public SB pj(String s) {
        this._sb.append(SB.escapeJava(s));
        return this;
    }

    @Override
    public SB p(IcedBitSet ibs) {
        return ibs.toString(this);
    }

    @Override
    public SB ii(int i) {
        this._indent += i;
        return this;
    }

    @Override
    public SB di(int i) {
        this._indent -= i;
        return this;
    }

    @Override
    public SB ci(JCodeSB sb) {
        this._indent = sb.getIndent();
        return this;
    }

    @Override
    public SB nl() {
        return this.p('\n');
    }

    @Override
    public SB toJavaStringInit(String[] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i = 0; i < ss.length - 1; ++i) {
            this.p('\"').pj(ss[i]).p("\",");
        }
        if (ss.length > 0) {
            this.p('\"').pj(ss[ss.length - 1]).p('\"');
        }
        return this.p('}');
    }

    @Override
    public SB toJavaStringInit(float[] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i = 0; i < ss.length - 1; ++i) {
            this.pj(ss[i]).p(',');
        }
        if (ss.length > 0) {
            this.pj(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SB toJavaStringInit(double[] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i = 0; i < ss.length - 1; ++i) {
            this.pj(ss[i]).p(',');
        }
        if (ss.length > 0) {
            this.pj(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SB toJavaStringInit(double[][] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i = 0; i < ss.length - 1; ++i) {
            this.toJavaStringInit(ss[i]).p(',');
        }
        if (ss.length > 0) {
            this.toJavaStringInit(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SB toJavaStringInit(double[][][] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i = 0; i < ss.length - 1; ++i) {
            this.toJavaStringInit(ss[i]).p(',');
        }
        if (ss.length > 0) {
            this.toJavaStringInit(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SB toJSArray(float[] nums) {
        this.p('[');
        for (int i = 0; i < nums.length; ++i) {
            if (i > 0) {
                this.p(',');
            }
            this.p(nums[i]);
        }
        return this.p(']');
    }

    @Override
    public SB toJSArray(String[] ss) {
        this.p('[');
        for (int i = 0; i < ss.length; ++i) {
            if (i > 0) {
                this.p(',');
            }
            this.p('\"').p(ss[i]).p('\"');
        }
        return this.p(']');
    }

    @Override
    public int getIndent() {
        return this._indent;
    }

    @Override
    public SB p(JCodeSB sb) {
        this._sb.append(sb.getContent());
        return this;
    }

    public String toString() {
        return this._sb.toString();
    }

    public static String escapeJava(String s) {
        assert (ILLEGAL_CHARACTERS.length == REPLACEMENTS.length);
        for (int i = 0; i < ILLEGAL_CHARACTERS.length; ++i) {
            Matcher m = ILLEGAL_CHARACTERS[i].matcher(s);
            s = m.replaceAll(REPLACEMENTS[i]);
        }
        return s;
    }

    @Override
    public String getContent() {
        return this._sb.toString();
    }
}

