/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import water.exceptions.JCodeSB;
import water.util.IcedBitSet;
import water.util.SB;

public class SBPrintStream
extends PrintStream
implements JCodeSB<SBPrintStream> {
    private int _indent = 0;

    public SBPrintStream(OutputStream out) {
        super(out);
    }

    public SBPrintStream(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public SBPrintStream(OutputStream out, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        super(out, autoFlush, encoding);
    }

    @Override
    public SBPrintStream ps(String s) {
        this.append("\"");
        this.pj(s);
        this.append("\"");
        return this;
    }

    @Override
    public SBPrintStream p(JCodeSB s) {
        return this.p(s.getContent());
    }

    @Override
    public SBPrintStream p(String s) {
        this.append(s);
        return this;
    }

    @Override
    public SBPrintStream p(float s) {
        if (Float.isNaN(s)) {
            this.append("Float.NaN");
        } else if (Float.isInfinite(s)) {
            this.append(s > 0.0f ? "Float.POSITIVE_INFINITY" : "Float.NEGATIVE_INFINITY");
        } else {
            this.append(s);
        }
        return this;
    }

    @Override
    public SBPrintStream p(double s) {
        if (Double.isNaN(s)) {
            this.append("Double.NaN");
        } else if (Double.isInfinite(s)) {
            this.append(s > 0.0 ? "Double.POSITIVE_INFINITY" : "Double.NEGATIVE_INFINITY");
        } else {
            this.append(s);
        }
        return this;
    }

    @Override
    public SBPrintStream p(char s) {
        this.append(s);
        return this;
    }

    @Override
    public SBPrintStream p(int s) {
        this.append(s);
        return this;
    }

    @Override
    public SBPrintStream p(long s) {
        this.append(s);
        return this;
    }

    @Override
    public SBPrintStream p(boolean s) {
        this.append(Boolean.toString(s));
        return this;
    }

    @Override
    public SBPrintStream pobj(Object s) {
        this.append(s.toString());
        return this;
    }

    @Override
    public SBPrintStream i(int d) {
        for (int i = 0; i < d + this._indent; ++i) {
            this.p("  ");
        }
        return this;
    }

    @Override
    public SBPrintStream i() {
        return this.i(0);
    }

    @Override
    public SBPrintStream ip(String s) {
        return this.i().p(s);
    }

    @Override
    public SBPrintStream s() {
        this.append(' ');
        return this;
    }

    @Override
    public SBPrintStream pj(double s) {
        if (Double.isInfinite(s)) {
            this.append("Double.").append(s > 0.0 ? "POSITIVE_INFINITY" : "NEGATIVE_INFINITY");
        } else if (Double.isNaN(s)) {
            this.append("Double.NaN");
        } else {
            this.append(s);
        }
        return this;
    }

    @Override
    public SBPrintStream pj(float s) {
        if (Float.isInfinite(s)) {
            this.append("Float.").append(s > 0.0f ? "POSITIVE_INFINITY" : "NEGATIVE_INFINITY");
        } else if (Float.isNaN(s)) {
            this.append("Float.NaN");
        } else {
            this.append(s).append('f');
        }
        return this;
    }

    @Override
    public SBPrintStream pj(String s) {
        this.append(SB.escapeJava(s));
        return this;
    }

    @Override
    public SBPrintStream p(IcedBitSet ibs) {
        SB sb = new SB();
        sb = ibs.toString(sb);
        return this.append(sb);
    }

    public SBPrintStream p(SB sb) {
        return this.append(sb);
    }

    @Override
    public SBPrintStream ii(int i) {
        this._indent += i;
        return this;
    }

    @Override
    public SBPrintStream di(int i) {
        this._indent -= i;
        return this;
    }

    @Override
    public SBPrintStream ci(JCodeSB sb) {
        this._indent = sb.getIndent();
        return this;
    }

    @Override
    public SBPrintStream nl() {
        return this.p('\n');
    }

    @Override
    public SBPrintStream toJavaStringInit(String[] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i = 0; i < ss.length - 1; ++i) {
            this.p('\"').pj(ss[i]).p("\",");
        }
        if (ss.length > 0) {
            this.p('\"').pj(ss[ss.length - 1]).p('\"');
        }
        return this.p('}');
    }

    @Override
    public SBPrintStream toJavaStringInit(float[] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i = 0; i < ss.length - 1; ++i) {
            this.pj(ss[i]).p(',');
        }
        if (ss.length > 0) {
            this.pj(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SBPrintStream toJavaStringInit(double[] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i = 0; i < ss.length - 1; ++i) {
            this.pj(ss[i]).p(',');
        }
        if (ss.length > 0) {
            this.pj(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SBPrintStream toJavaStringInit(double[][] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i = 0; i < ss.length - 1; ++i) {
            this.toJavaStringInit(ss[i]).p(',');
        }
        if (ss.length > 0) {
            this.toJavaStringInit(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SBPrintStream toJavaStringInit(double[][][] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i = 0; i < ss.length - 1; ++i) {
            this.toJavaStringInit(ss[i]).p(',');
        }
        if (ss.length > 0) {
            this.toJavaStringInit(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SBPrintStream toJSArray(float[] nums) {
        this.p('[');
        for (int i = 0; i < nums.length; ++i) {
            if (i > 0) {
                this.p(',');
            }
            this.p(nums[i]);
        }
        return this.p(']');
    }

    @Override
    public SBPrintStream toJSArray(String[] ss) {
        this.p('[');
        for (int i = 0; i < ss.length; ++i) {
            if (i > 0) {
                this.p(',');
            }
            this.p('\"').p(ss[i]).p('\"');
        }
        return this.p(']');
    }

    @Override
    public int getIndent() {
        return this._indent;
    }

    @Override
    public String getContent() {
        throw new UnsupportedOperationException("Cannot get content of stream!");
    }

    public SBPrintStream append(float f) {
        this.append(Float.toString(f));
        return this;
    }

    public SBPrintStream append(double d) {
        this.append(Double.toString(d));
        return this;
    }

    public SBPrintStream append(int i) {
        this.append(Integer.toString(i));
        return this;
    }

    public SBPrintStream append(long l) {
        this.append(Long.toString(l));
        return this;
    }

    public SBPrintStream append(SB sb) {
        this.append(sb.toString());
        return this;
    }
}

