/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Model;
import hex.genmodel.AbstractMojoWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipOutputStream;
import water.api.SchemaServer;
import water.api.StreamWriter;
import water.api.schemas3.ModelSchemaV3;

public abstract class ModelMojoWriter<M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output>
extends AbstractMojoWriter
implements StreamWriter {
    protected M model;

    public ModelMojoWriter() {
        super(null);
    }

    public ModelMojoWriter(M model) {
        super(((Model)model).modelDescriptor());
        this.model = model;
    }

    @Override
    public final void writeTo(OutputStream os) {
        ZipOutputStream zos = new ZipOutputStream(os);
        try {
            this.writeTo(zos);
            zos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeExtraInfo() throws IOException {
        this.writeModelDetails();
        this.writeModelDetailsReadme();
    }

    private void writeModelDetails() throws IOException {
        ModelSchemaV3 modelSchema = (ModelSchemaV3)SchemaServer.schema(3, this.model).fillFromImpl(this.model);
        this.startWritingTextFile("experimental/modelDetails.json");
        this.writeln(modelSchema.toJsonString());
        this.finishWritingTextFile();
    }

    private void writeModelDetailsReadme() throws IOException {
        this.startWritingTextFile("experimental/README.md");
        this.writeln("Outputting model information in JSON is an experimental feature and we appreciate any feedback.\nThe contents of this folder may change with another version of H2O.");
        this.finishWritingTextFile();
    }
}

