/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.GainsLift;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsOrdinal;
import hex.ModelMetricsRegression;
import java.util.Arrays;
import water.H2O;
import water.Iced;
import water.exceptions.H2OIllegalArgumentException;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MathUtils;

public class ScoreKeeper
extends Iced {
    public double _mean_residual_deviance = Double.NaN;
    public double _mse = Double.NaN;
    public double _rmse = Double.NaN;
    public double _mae = Double.NaN;
    public double _rmsle = Double.NaN;
    public double _logloss = Double.NaN;
    public double _AUC = Double.NaN;
    public double _pr_auc = Double.NaN;
    public double _classError = Double.NaN;
    public double _mean_per_class_error = Double.NaN;
    public double _custom_metric = Double.NaN;
    public float[] _hitratio;
    public double _lift = Double.NaN;
    public double _r2 = Double.NaN;
    public double _anomaly_score = Double.NaN;
    public double _anomaly_score_normalized = Double.NaN;

    public ScoreKeeper() {
    }

    public ScoreKeeper(double mse) {
        this._mse = mse;
    }

    public ScoreKeeper(ModelMetrics mm) {
        this.fillFrom(mm);
    }

    public ScoreKeeper(Model m) {
        if (null == m) {
            throw new H2OIllegalArgumentException("model", "ScoreKeeper(Model model)", null);
        }
        if (null == m._output) {
            throw new H2OIllegalArgumentException("model._output", "ScoreKeeper(Model model)", null);
        }
        if (null != ((Model.Output)m._output)._cross_validation_metrics) {
            this.fillFrom(((Model.Output)m._output)._cross_validation_metrics);
        } else if (null != ((Model.Output)m._output)._validation_metrics) {
            this.fillFrom(((Model.Output)m._output)._validation_metrics);
        } else {
            this.fillFrom(((Model.Output)m._output)._training_metrics);
        }
    }

    public boolean isEmpty() {
        return Double.isNaN(this._mse) && Double.isNaN(this._logloss);
    }

    public void fillFrom(ModelMetrics m) {
        if (m == null) {
            return;
        }
        this._mse = m._MSE;
        this._rmse = m.rmse();
        if (m instanceof ModelMetricsRegression) {
            this._mean_residual_deviance = ((ModelMetricsRegression)m)._mean_residual_deviance;
            this._mae = ((ModelMetricsRegression)m)._mean_absolute_error;
            this._rmsle = ((ModelMetricsRegression)m)._root_mean_squared_log_error;
            this._r2 = ((ModelMetricsRegression)m).r2();
        }
        if (m instanceof ModelMetricsBinomial) {
            GainsLift gl;
            this._logloss = ((ModelMetricsBinomial)m)._logloss;
            this._r2 = ((ModelMetricsBinomial)m).r2();
            if (((ModelMetricsBinomial)m)._auc != null) {
                this._AUC = ((ModelMetricsBinomial)m)._auc._auc;
                this._pr_auc = ((ModelMetricsBinomial)m)._auc.pr_auc();
                this._classError = ((ModelMetricsBinomial)m)._auc.defaultErr();
                this._mean_per_class_error = ((ModelMetricsBinomial)m).mean_per_class_error();
            }
            if ((gl = ((ModelMetricsBinomial)m)._gainsLift) != null && gl.response_rates != null && gl.response_rates.length > 0) {
                this._lift = gl.response_rates[0] / gl.avg_response_rate;
            }
        } else if (m instanceof ModelMetricsMultinomial) {
            this._logloss = ((ModelMetricsMultinomial)m)._logloss;
            this._classError = ((ModelMetricsMultinomial)m)._cm.err();
            this._mean_per_class_error = ((ModelMetricsMultinomial)m).mean_per_class_error();
            this._hitratio = ((ModelMetricsMultinomial)m)._hit_ratios;
            this._r2 = ((ModelMetricsMultinomial)m).r2();
        } else if (m instanceof ModelMetricsOrdinal) {
            this._logloss = ((ModelMetricsOrdinal)m)._logloss;
            this._classError = ((ModelMetricsOrdinal)m)._cm.err();
            this._mean_per_class_error = ((ModelMetricsOrdinal)m).mean_per_class_error();
            this._hitratio = ((ModelMetricsOrdinal)m)._hit_ratios;
            this._r2 = ((ModelMetricsOrdinal)m).r2();
        } else if (m instanceof ScoreKeeperAware) {
            ((ScoreKeeperAware)((Object)m)).fillTo(this);
        }
        if (m._custom_metric != null) {
            this._custom_metric = m._custom_metric.value;
        }
    }

    static boolean moreIsBetter(StoppingMetric criterion) {
        return criterion == StoppingMetric.AUC || criterion == StoppingMetric.lift_top_group || criterion == StoppingMetric.custom_increasing;
    }

    private static boolean hasLowerBound(StoppingMetric criterion) {
        return criterion != StoppingMetric.deviance;
    }

    public static boolean stopEarly(ScoreKeeper[] sk, int k, boolean classification, StoppingMetric criterion, double rel_improvement, String what, boolean verbose) {
        boolean improved;
        if (k == 0) {
            return false;
        }
        int len = sk.length - 1;
        if (len < 2 * k) {
            return false;
        }
        if (criterion == StoppingMetric.AUTO) {
            criterion = classification ? StoppingMetric.logloss : StoppingMetric.deviance;
        }
        boolean moreIsBetter = ScoreKeeper.moreIsBetter(criterion);
        boolean hasLowerBound = ScoreKeeper.hasLowerBound(criterion);
        double[] movingAvg = new double[k + 1];
        double lastBeforeK = moreIsBetter ? -1.7976931348623157E308 : Double.MAX_VALUE;
        double bestInLastK = moreIsBetter ? -1.7976931348623157E308 : Double.MAX_VALUE;
        for (int i = 0; i < movingAvg.length; ++i) {
            movingAvg[i] = 0.0;
            int startIdx = sk.length - 2 * k + i;
            for (int j = 0; j < k; ++j) {
                double val;
                ScoreKeeper skj = sk[startIdx + j];
                switch (criterion) {
                    case AUC: {
                        val = skj._AUC;
                        break;
                    }
                    case MSE: {
                        val = skj._mse;
                        break;
                    }
                    case RMSE: {
                        val = skj._rmse;
                        break;
                    }
                    case MAE: {
                        val = skj._mae;
                        break;
                    }
                    case RMSLE: {
                        val = skj._rmsle;
                        break;
                    }
                    case deviance: {
                        val = skj._mean_residual_deviance;
                        break;
                    }
                    case logloss: {
                        val = skj._logloss;
                        break;
                    }
                    case misclassification: {
                        val = skj._classError;
                        break;
                    }
                    case mean_per_class_error: {
                        val = skj._mean_per_class_error;
                        break;
                    }
                    case lift_top_group: {
                        val = skj._lift;
                        break;
                    }
                    case custom: 
                    case custom_increasing: {
                        val = skj._custom_metric;
                        break;
                    }
                    default: {
                        throw H2O.unimpl("Undefined stopping criterion.");
                    }
                }
                int n = i;
                movingAvg[n] = movingAvg[n] + val;
            }
            int n = i;
            movingAvg[n] = movingAvg[n] / (double)k;
            if (Double.isNaN(movingAvg[i])) {
                return false;
            }
            if (i == 0) {
                lastBeforeK = movingAvg[i];
                continue;
            }
            bestInLastK = moreIsBetter ? Math.max(movingAvg[i], bestInLastK) : Math.min(movingAvg[i], bestInLastK);
        }
        if (Math.signum(ArrayUtils.maxValue(movingAvg)) != Math.signum(ArrayUtils.minValue(movingAvg))) {
            return false;
        }
        if (Math.signum(bestInLastK) != Math.signum(lastBeforeK)) {
            return false;
        }
        assert (lastBeforeK != Double.MAX_VALUE);
        assert (bestInLastK != Double.MAX_VALUE);
        if (verbose) {
            Log.info("Windowed averages (window size " + k + ") of " + what + " " + (k + 1) + " " + criterion.toString() + " metrics: " + Arrays.toString(movingAvg));
        }
        if (lastBeforeK == 0.0 && !moreIsBetter && hasLowerBound) {
            return true;
        }
        double ratio = bestInLastK / lastBeforeK;
        if (Double.isNaN(ratio)) {
            return false;
        }
        boolean bl = moreIsBetter ? ratio > 1.0 + rel_improvement : (improved = ratio < 1.0 - rel_improvement);
        if (verbose) {
            Log.info("Checking convergence with " + criterion.toString() + " metric: " + lastBeforeK + " --> " + bestInLastK + (improved ? " (still improving)." : " (converged)."));
        }
        return !improved;
    }

    public boolean equals(Object that) {
        if (!(that instanceof ScoreKeeper)) {
            return false;
        }
        ScoreKeeper o = (ScoreKeeper)that;
        if (this._hitratio == null && ((ScoreKeeper)that)._hitratio != null) {
            return false;
        }
        if (this._hitratio != null && ((ScoreKeeper)that)._hitratio == null) {
            return false;
        }
        if (this._hitratio != null && ((ScoreKeeper)that)._hitratio != null) {
            if (this._hitratio.length != ((ScoreKeeper)that)._hitratio.length) {
                return false;
            }
            for (int i = 0; i < this._hitratio.length; ++i) {
                if (MathUtils.compare(this._hitratio[i], ((ScoreKeeper)that)._hitratio[i], 1.0E-6, 1.0E-6)) continue;
                return false;
            }
        }
        return MathUtils.compare(this._mean_residual_deviance, o._mean_residual_deviance, 1.0E-6, 1.0E-6) && MathUtils.compare(this._mse, o._mse, 1.0E-6, 1.0E-6) && MathUtils.compare(this._mae, o._mae, 1.0E-6, 1.0E-6) && MathUtils.compare(this._rmsle, o._rmsle, 1.0E-6, 1.0E-6) && MathUtils.compare(this._logloss, o._logloss, 1.0E-6, 1.0E-6) && MathUtils.compare(this._classError, o._classError, 1.0E-6, 1.0E-6) && MathUtils.compare(this._mean_per_class_error, o._mean_per_class_error, 1.0E-6, 1.0E-6) && MathUtils.compare(this._r2, o._r2, 1.0E-6, 1.0E-6) && MathUtils.compare(this._lift, o._lift, 1.0E-6, 1.0E-6);
    }

    public String toString() {
        return "ScoreKeeper{  _mean_residual_deviance=" + this._mean_residual_deviance + ", _rmse=" + this._rmse + ",_mae=" + this._mae + ",_rmsle=" + this._rmsle + ", _logloss=" + this._logloss + ", _AUC=" + this._AUC + ", _pr_auc=" + this._pr_auc + ", _classError=" + this._classError + ", _mean_per_class_error=" + this._mean_per_class_error + ", _hitratio=" + Arrays.toString(this._hitratio) + ", _lift=" + this._lift + '}';
    }

    public static interface ScoreKeeperAware {
        public void fillTo(ScoreKeeper var1);
    }

    public static enum StoppingMetric {
        AUTO,
        deviance,
        logloss,
        MSE,
        RMSE,
        MAE,
        RMSLE,
        AUC,
        lift_top_group,
        misclassification,
        mean_per_class_error,
        custom,
        custom_increasing;

    }
}

