/*
 * Decompiled with CFR 0.152.
 */
package hex.quantile;

import hex.ModelBuilder;
import hex.ModelCategory;
import hex.quantile.QuantileModel;
import java.util.Arrays;
import water.H2O;
import water.Job;
import water.Lockable;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;

public class Quantile
extends ModelBuilder<QuantileModel, QuantileModel.QuantileParameters, QuantileModel.QuantileOutput> {
    private int _ncols;

    @Override
    protected boolean logMe() {
        return false;
    }

    @Override
    public boolean isSupervised() {
        return false;
    }

    public Quantile(QuantileModel.QuantileParameters parms) {
        super(parms);
        this.init(false);
    }

    public Quantile(QuantileModel.QuantileParameters parms, Job job) {
        super(parms, job);
        this.init(false);
    }

    @Override
    public ModelBuilder.Driver trainModelImpl() {
        return new QuantileDriver();
    }

    @Override
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Unknown};
    }

    @Override
    protected int desiredChunks(Frame original_fr, boolean local) {
        return 1;
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        for (double p : ((QuantileModel.QuantileParameters)this._parms)._probs) {
            if (!(p < 0.0) && !(p > 1.0)) continue;
            this.error("_probs", "Probabilities must be between 0 and 1");
        }
        this._ncols = this.train().numCols() - this.numSpecialCols();
        if (this.numSpecialCols() == 1 && this._weights == null) {
            throw new IllegalArgumentException("The only special Vec that is supported for Quantiles is observation weights.");
        }
        if (this.numSpecialCols() > 1) {
            throw new IllegalArgumentException("Cannot handle more than 1 special vec (weights)");
        }
    }

    static double computeQuantile(double lo, double hi, double row, double nrows, double prob, QuantileModel.CombineMethod method) {
        if (lo == hi) {
            return lo;
        }
        if (method == null) {
            method = QuantileModel.CombineMethod.INTERPOLATE;
        }
        switch (method) {
            case INTERPOLATE: {
                return Quantile.linearInterpolate(lo, hi, row, nrows, prob);
            }
            case AVERAGE: {
                return 0.5 * (hi + lo);
            }
            case LOW: {
                return lo;
            }
            case HIGH: {
                return hi;
            }
        }
        Log.info("Unknown even sample size quantile combination type: " + (Object)((Object)method) + ". Doing linear interpolation.");
        return Quantile.linearInterpolate(lo, hi, row, nrows, prob);
    }

    private static double linearInterpolate(double lo, double hi, double row, double nrows, double prob) {
        double plo = (row + 0.0) / (nrows - 1.0);
        double phi = (row + 1.0) / (nrows - 1.0);
        assert (plo <= prob && prob <= phi);
        return lo + (hi - lo) * (prob - plo) / (phi - plo);
    }

    private static final class Histo
    extends MRTask<Histo> {
        private static final int NBINS = 1024;
        private final int _nbins;
        private final double _lb;
        private final double _step;
        private final double _start_row;
        private final double _nrows;
        private final boolean _isInt;
        double[] _bins;
        double[] _mins;
        double[] _maxs;

        private Histo(double lb, double ub, double start_row, double nrows, boolean isInt) {
            boolean is_int = isInt && ub - lb < 1024.0;
            this._nbins = is_int ? (int)(ub - lb + 1.0) : 1024;
            this._lb = lb;
            double ulp = Math.ulp(Math.max(Math.abs(lb), Math.abs(ub)));
            this._step = is_int ? 1.0 : (ub + ulp - lb) / (double)this._nbins;
            this._start_row = start_row;
            this._nrows = nrows;
            this._isInt = isInt;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("range : " + this._lb + " ... " + (this._lb + (double)this._nbins * this._step));
            sb.append("\npsum0 : " + this._start_row);
            sb.append("\ncounts: " + Arrays.toString(this._bins));
            sb.append("\nmaxs  : " + Arrays.toString(this._maxs));
            sb.append("\nmins  : " + Arrays.toString(this._mins));
            sb.append("\n");
            return sb.toString();
        }

        @Override
        public void map(Chunk chk, Chunk weight) {
            this._bins = new double[this._nbins];
            this._mins = new double[this._nbins];
            this._maxs = new double[this._nbins];
            Arrays.fill(this._mins, Double.MAX_VALUE);
            Arrays.fill(this._maxs, -1.7976931348623157E308);
            for (int row = 0; row < chk._len; ++row) {
                double idx;
                double d;
                double w = weight.atd(row);
                if (w == 0.0 || Double.isNaN(d = chk.atd(row)) || !(0.0 <= (idx = (d - this._lb) / this._step)) || !(idx < (double)this._bins.length)) continue;
                int i = (int)idx;
                if (this._bins[i] == 0.0) {
                    this._mins[i] = this._maxs[i] = d;
                } else {
                    if (d < this._mins[i]) {
                        this._mins[i] = d;
                    }
                    if (d > this._maxs[i]) {
                        this._maxs[i] = d;
                    }
                }
                int n = i;
                this._bins[n] = this._bins[n] + w;
            }
        }

        @Override
        public void map(Chunk chk) {
            this.map(chk, new C0DChunk(1.0, chk.len()));
        }

        @Override
        public void reduce(Histo h) {
            for (int i = 0; i < this._nbins; ++i) {
                if (this._mins[i] > h._mins[i]) {
                    this._mins[i] = h._mins[i];
                }
                if (!(this._maxs[i] < h._maxs[i])) continue;
                this._maxs[i] = h._maxs[i];
            }
            ArrayUtils.add(this._bins, h._bins);
        }

        double findQuantile(double prob, QuantileModel.CombineMethod method) {
            double hi;
            double lo;
            double p2 = prob * (this._nrows - 1.0);
            long r2 = (long)p2;
            int loidx = this.findBin(r2);
            double d = lo = loidx == this._nbins ? this.binEdge(this._nbins) : this._maxs[loidx];
            if (loidx < this._nbins && (double)r2 == p2 && this._mins[loidx] == lo) {
                return lo;
            }
            long r3 = r2 + 1L;
            int hiidx = this.findBin(r3);
            double d2 = hi = hiidx == this._nbins ? this.binEdge(this._nbins) : this._mins[hiidx];
            if (loidx == hiidx) {
                return lo == hi ? lo : Double.NaN;
            }
            return Quantile.computeQuantile(lo, hi, r2, this._nrows, prob, method);
        }

        private double binEdge(int idx) {
            return this._lb + this._step * (double)idx;
        }

        private int findBin(double row) {
            long sum = (long)this._start_row;
            for (int i = 0; i < this._nbins; ++i) {
                if ((long)row >= (sum = (long)((double)sum + this._bins[i]))) continue;
                return i;
            }
            return this._nbins;
        }

        Histo refinePass(double prob) {
            double prow = prob * (this._nrows - 1.0);
            long lorow = (long)prow;
            int loidx = this.findBin(lorow);
            assert (loidx < this._nbins);
            double lo = this._mins[loidx];
            long hirow = (double)lorow == prow ? lorow : lorow + 1L;
            int hiidx = this.findBin(hirow);
            double hi = hiidx == this._nbins ? this.binEdge(this._nbins) : this._maxs[hiidx];
            long sum = (long)this._start_row;
            for (int i = 0; i < loidx; ++i) {
                sum = (long)((double)sum + this._bins[i]);
            }
            return new Histo(lo, hi, sum, this._nrows, this._isInt);
        }
    }

    public static class StratifiedQuantilesTask
    extends H2O.H2OCountedCompleter<StratifiedQuantilesTask> {
        final double _prob;
        final Vec _response;
        final Vec _weights;
        final Vec _strata;
        final QuantileModel.CombineMethod _combine_method;
        public double[] _quantiles;
        public int[] _nids;

        public StratifiedQuantilesTask(H2O.H2OCountedCompleter cc, double prob, Vec response, Vec weights, Vec strata, QuantileModel.CombineMethod combine_method) {
            super(cc);
            this._response = response;
            this._prob = prob;
            this._combine_method = combine_method;
            this._weights = weights;
            this._strata = strata;
        }

        @Override
        public void compute2() {
            int strataMin = (int)this._strata.min();
            int strataMax = (int)this._strata.max();
            if (strataMin < 0 && strataMax < 0) {
                Log.warn("No quantiles can be computed since there are no non-OOB rows.");
                this.tryComplete();
                return;
            }
            int nstrata = strataMax - strataMin + 1;
            Log.info("Computing quantiles for (up to) " + nstrata + " different strata.");
            this._quantiles = new double[nstrata];
            this._nids = new int[nstrata];
            Arrays.fill(this._quantiles, Double.NaN);
            Vec weights = this._weights != null ? this._weights : this._response.makeCon(1.0);
            for (int i = 0; i < nstrata; ++i) {
                Vec newWeights = weights.makeCopy();
                if (this._strata != null) {
                    this._nids[i] = strataMin + i;
                    new KeepOnlyOneStrata(this._nids[i]).doAll(this._strata, newWeights);
                }
                Vec[] vecArray = new Vec[]{this._response, newWeights};
                double sumRows = ((SumWeights)new SumWeights().doAll((Vec[])vecArray)).sum;
                if (!(sumRows > 0.0)) continue;
                Histo h = new Histo(this._response.min(), this._response.max(), 0.0, sumRows, this._response.isInt());
                h.doAll(this._response, newWeights);
                while (Double.isNaN(this._quantiles[i] = h.findQuantile(this._prob, this._combine_method))) {
                    h = (Histo)h.refinePass(this._prob).doAll(this._response, newWeights);
                }
                newWeights.remove();
                assert (this._quantiles[i] <= this._response.max() + 1.0E-6);
                assert (this._quantiles[i] >= this._response.min() - 1.0E-6);
            }
            if (this._weights != weights) {
                weights.remove();
            }
            this.tryComplete();
        }

        private static class KeepOnlyOneStrata
        extends MRTask<KeepOnlyOneStrata> {
            int stratumToKeep;

            KeepOnlyOneStrata(int stratumToKeep) {
                this.stratumToKeep = stratumToKeep;
            }

            @Override
            public void map(Chunk strata, Chunk newW) {
                for (int i = 0; i < strata._len; ++i) {
                    if ((int)strata.at8(i) == this.stratumToKeep) continue;
                    newW.set(i, 0L);
                }
            }
        }
    }

    private class QuantileDriver
    extends ModelBuilder.Driver {
        private QuantileDriver() {
            super(Quantile.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void computeImpl() {
            Lockable model = null;
            try {
                Quantile.this.init(true);
                model = new QuantileModel(Quantile.this.dest(), (QuantileModel.QuantileParameters)Quantile.this._parms, new QuantileModel.QuantileOutput(Quantile.this));
                ((QuantileModel.QuantileOutput)((QuantileModel)model)._output)._parameters = (QuantileModel.QuantileParameters)Quantile.this._parms;
                ((QuantileModel.QuantileOutput)((QuantileModel)model)._output)._quantiles = new double[Quantile.this._ncols][((QuantileModel.QuantileParameters)Quantile.this._parms)._probs.length];
                model.delete_and_lock(Quantile.this._job);
                Vec[] vecs = Quantile.this.train().vecs();
                for (int n = 0; n < Quantile.this._ncols; ++n) {
                    if (Quantile.this.stop_requested()) {
                        return;
                    }
                    Vec vec = vecs[n];
                    if (vec.isBad() || vec.isCategorical() || vec.isString() || vec.isTime() || vec.isUUID()) {
                        ((QuantileModel.QuantileOutput)((QuantileModel)model)._output)._quantiles[n] = new double[((QuantileModel.QuantileParameters)Quantile.this._parms)._probs.length];
                        Arrays.fill(((QuantileModel.QuantileOutput)((QuantileModel)model)._output)._quantiles[n], Double.NaN);
                        continue;
                    }
                    double sumRows = Quantile.this._weights == null ? (double)(vec.length() - vec.naCnt()) : ((SumWeights)new SumWeights().doAll((Vec[])new Vec[]{vec, ((Quantile)Quantile.this)._weights})).sum;
                    Histo h1 = new Histo(vec.min(), vec.max(), 0.0, sumRows, vec.isInt());
                    h1 = Quantile.this._weights == null ? (Histo)h1.doAll(vec) : (Histo)h1.doAll(vec, Quantile.this._weights);
                    for (int p = 0; p < ((QuantileModel.QuantileParameters)Quantile.this._parms)._probs.length; ++p) {
                        double prob = ((QuantileModel.QuantileParameters)Quantile.this._parms)._probs[p];
                        Histo h = h1;
                        ++((QuantileModel.QuantileOutput)((QuantileModel)model)._output)._iterations;
                        while (Double.isNaN(((QuantileModel.QuantileOutput)((QuantileModel)model)._output)._quantiles[n][p] = h.findQuantile(prob, ((QuantileModel.QuantileParameters)Quantile.this._parms)._combine_method))) {
                            h = Quantile.this._weights == null ? (Histo)h.refinePass(prob).doAll(vec) : (Histo)h.refinePass(prob).doAll(vec, Quantile.this._weights);
                            ++((QuantileModel.QuantileOutput)((QuantileModel)model)._output)._iterations;
                        }
                        model.update(Quantile.this._job);
                        Quantile.this._job.update(0L);
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("Quantile: iter: ").append(((QuantileModel.QuantileOutput)((QuantileModel)model)._output)._iterations).append(" Qs=").append(Arrays.toString(((QuantileModel.QuantileOutput)((QuantileModel)model)._output)._quantiles[n]));
                    Log.debug(sb);
                }
            }
            finally {
                if (model != null) {
                    model.unlock(Quantile.this._job);
                }
            }
        }
    }

    private static class SumWeights
    extends MRTask<SumWeights> {
        double sum;

        private SumWeights() {
        }

        @Override
        public void map(Chunk c, Chunk w) {
            for (int i = 0; i < c.len(); ++i) {
                if (c.isNA(i)) continue;
                double wt = w.atd(i);
                this.sum += wt;
            }
        }

        @Override
        public void reduce(SumWeights mrt) {
            this.sum += mrt.sum;
        }
    }
}

