/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.H2O;
import water.H2ONode;

class ClientDisconnectCheckThread
extends Thread {
    public ClientDisconnectCheckThread() {
        super("ClientDisconnectCheckThread");
        this.setDaemon(true);
    }

    private boolean isTimeoutExceeded(H2ONode client, long timeout) {
        return System.currentTimeMillis() - client._last_heard_from >= timeout;
    }

    private void handleClientDisconnect(H2ONode client) {
        if (client != H2O.SELF) {
            if (H2O.isFlatfileEnabled()) {
                H2O.removeNodeFromFlatfile(client);
            }
            H2O.removeClient(client);
        }
    }

    @Override
    public void run() {
        while (true) {
            for (H2ONode client : H2O.getClients()) {
                if (!this.isTimeoutExceeded(client, H2O.ARGS.clientDisconnectTimeout)) continue;
                this.handleClientDisconnect(client);
            }
            try {
                Thread.sleep(H2O.ARGS.clientDisconnectTimeout);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

