/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import water.AutoBuffer;
import water.ExternalFrameUtils;
import water.fvec.ChunkUtils;
import water.fvec.NewChunk;

final class ExternalFrameWriterBackend {
    ExternalFrameWriterBackend() {
    }

    static void handleWriteToChunk(ByteChannel sock, AutoBuffer ab) throws IOException {
        String frameKey = ab.getStr();
        byte[] expectedTypes = ab.getA1();
        if (expectedTypes == null) {
            throw new RuntimeException("Expected types can't be null.");
        }
        int[] maxVecSizes = ab.getA4();
        int[] elemSizes = ExternalFrameUtils.getElemSizes(expectedTypes, maxVecSizes != null ? maxVecSizes : ExternalFrameUtils.EMPTY_ARI);
        int[] startPos = ExternalFrameUtils.getStartPositions(elemSizes);
        byte[] vecTypes = ExternalFrameUtils.vecTypesFromExpectedTypes(expectedTypes, maxVecSizes != null ? maxVecSizes : ExternalFrameUtils.EMPTY_ARI);
        int expectedNumRows = ab.getInt();
        int chunk_id = ab.getInt();
        NewChunk[] nchnk = ChunkUtils.createNewChunks(frameKey, vecTypes, chunk_id);
        assert (nchnk != null);
        for (int currentRowIdx = 0; currentRowIdx < expectedNumRows; ++currentRowIdx) {
            block12: for (int typeIdx = 0; typeIdx < expectedTypes.length; ++typeIdx) {
                switch (expectedTypes[typeIdx]) {
                    case 0: 
                    case 1: {
                        ExternalFrameWriterBackend.store(ab, nchnk[startPos[typeIdx]], ab.get1());
                        continue block12;
                    }
                    case 2: {
                        ExternalFrameWriterBackend.store(ab, nchnk[startPos[typeIdx]], ab.get2());
                        continue block12;
                    }
                    case 3: {
                        ExternalFrameWriterBackend.store(ab, nchnk[startPos[typeIdx]], ab.get2s());
                        continue block12;
                    }
                    case 4: {
                        ExternalFrameWriterBackend.store(ab, nchnk[startPos[typeIdx]], ab.getInt());
                        continue block12;
                    }
                    case 6: 
                    case 9: {
                        ExternalFrameWriterBackend.store(ab, nchnk[startPos[typeIdx]], ab.get8());
                        continue block12;
                    }
                    case 5: {
                        ExternalFrameWriterBackend.store(nchnk[startPos[typeIdx]], ab.get4f());
                        continue block12;
                    }
                    case 7: {
                        ExternalFrameWriterBackend.store(nchnk[startPos[typeIdx]], ab.get8d());
                        continue block12;
                    }
                    case 8: {
                        ExternalFrameWriterBackend.store(ab, nchnk[startPos[typeIdx]], ab.getStr());
                        continue block12;
                    }
                    case 10: {
                        ExternalFrameWriterBackend.storeVector(ab, nchnk, elemSizes[typeIdx], startPos[typeIdx]);
                        continue block12;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown expected type: " + expectedTypes[typeIdx]);
                    }
                }
            }
        }
        ChunkUtils.closeNewChunks(nchnk);
        AutoBuffer outputAb = new AutoBuffer();
        outputAb.put1(2);
        ExternalFrameUtils.writeToChannel(outputAb, sock);
    }

    private static void storeVector(AutoBuffer ab, NewChunk[] nchnk, int maxVecSize, int startPos) {
        boolean isSparse = ab.getZ();
        if (isSparse) {
            int[] indices = ab.getA4();
            double[] values = ab.getA8d();
            if (values == null) {
                throw new RuntimeException("Values of sparse Vector can't be null!");
            }
            if (indices == null) {
                throw new RuntimeException("Indices of sparse Vector can't be null!");
            }
            int zeroSectionStart = 0;
            for (int i = 0; i < indices.length; ++i) {
                for (int zeroIdx = zeroSectionStart; zeroIdx < indices[i]; ++zeroIdx) {
                    ExternalFrameWriterBackend.store(nchnk[startPos + zeroIdx], 0.0);
                }
                ExternalFrameWriterBackend.store(nchnk[startPos + indices[i]], values[i]);
                zeroSectionStart = indices[i] + 1;
            }
            for (int j = zeroSectionStart; j < maxVecSize; ++j) {
                ExternalFrameWriterBackend.store(nchnk[startPos + j], 0.0);
            }
        } else {
            int j;
            double[] values = ab.getA8d();
            if (values == null) {
                throw new RuntimeException("Values of dense Vector can't be null!");
            }
            for (j = 0; j < values.length; ++j) {
                ExternalFrameWriterBackend.store(nchnk[startPos + j], values[j]);
            }
            for (j = values.length; j < maxVecSize; ++j) {
                ExternalFrameWriterBackend.store(nchnk[startPos + j], 0.0);
            }
        }
    }

    private static void store(AutoBuffer ab, NewChunk chunk, long data) {
        if (ExternalFrameUtils.isNA(ab, data)) {
            chunk.addNA();
        } else {
            chunk.addNum(data);
        }
    }

    private static void store(NewChunk chunk, double data) {
        if (ExternalFrameUtils.isNA(data)) {
            chunk.addNA();
        } else {
            chunk.addNum(data);
        }
    }

    private static void store(AutoBuffer ab, NewChunk chunk, String data) {
        if (ExternalFrameUtils.isNA(ab, data)) {
            chunk.addNA();
        } else {
            chunk.addStr(data);
        }
    }
}

