/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.sql.Timestamp;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import water.AutoBuffer;
import water.ExternalFrameConfirmationCheck;
import water.ExternalFrameConfirmationException;
import water.ExternalFrameUtils;

public final class ExternalFrameWriterClient {
    private AutoBuffer ab = new AutoBuffer();
    private ByteChannel channel;
    private byte[] expectedTypes;
    private int currentColIdx = 0;

    public ExternalFrameWriterClient(ByteChannel channel) {
        this.channel = channel;
    }

    public void createChunks(String frameKey, byte[] expectedTypes, int chunkId, int totalNumRows, int[] maxVecSizes) throws IOException {
        this.ab.put1(42);
        this.ab.put1(0);
        this.ab.putStr(frameKey);
        this.expectedTypes = expectedTypes;
        this.ab.putA1(expectedTypes);
        this.ab.putA4(maxVecSizes);
        this.ab.putInt(totalNumRows);
        this.ab.putInt(chunkId);
        ExternalFrameUtils.writeToChannel(this.ab, this.channel);
    }

    public void sendBoolean(boolean data) throws IOException {
        ExternalFrameUtils.sendBoolean(this.ab, this.channel, data);
        this.increaseCurrentColIdx();
    }

    public void sendByte(byte data) throws IOException {
        ExternalFrameUtils.sendByte(this.ab, this.channel, data);
        this.increaseCurrentColIdx();
    }

    public void sendChar(char data) throws IOException {
        ExternalFrameUtils.sendChar(this.ab, this.channel, data);
        this.increaseCurrentColIdx();
    }

    public void sendShort(short data) throws IOException {
        ExternalFrameUtils.sendShort(this.ab, this.channel, data);
        this.increaseCurrentColIdx();
    }

    public void sendInt(int data) throws IOException {
        ExternalFrameUtils.sendInt(this.ab, this.channel, data);
        this.increaseCurrentColIdx();
    }

    public void sendLong(long data) throws IOException {
        ExternalFrameUtils.sendLong(this.ab, this.channel, data);
        this.increaseCurrentColIdx();
    }

    public void sendFloat(float data) throws IOException {
        ExternalFrameUtils.sendFloat(this.ab, this.channel, data);
        this.increaseCurrentColIdx();
    }

    public void sendDouble(double data) throws IOException {
        ExternalFrameUtils.sendDouble(this.ab, this.channel, data);
        this.increaseCurrentColIdx();
    }

    public void sendString(String data) throws IOException {
        ExternalFrameUtils.sendString(this.ab, this.channel, data);
        this.increaseCurrentColIdx();
    }

    public void sendTimestamp(Timestamp timestamp) throws IOException {
        ExternalFrameUtils.sendTimestamp(this.ab, this.channel, timestamp);
        this.increaseCurrentColIdx();
    }

    public void sendNA() throws IOException {
        ExternalFrameUtils.sendNA(this.ab, this.channel, this.expectedTypes[this.currentColIdx]);
        this.increaseCurrentColIdx();
    }

    public void sendSparseVector(int[] indices, double[] values) throws IOException {
        this.sendBoolean(true);
        ExternalFrameUtils.sendIntArray(this.ab, this.channel, indices);
        ExternalFrameUtils.sendDoubleArray(this.ab, this.channel, values);
    }

    public void sendDenseVector(double[] values) throws IOException {
        this.sendBoolean(false);
        ExternalFrameUtils.sendDoubleArray(this.ab, this.channel, values);
    }

    public void waitUntilAllWritten(int timeout) throws ExternalFrameConfirmationException {
        AutoBuffer confirmAb = new AutoBuffer(this.channel);
        try {
            byte flag = ExternalFrameConfirmationCheck.getConfirmation(confirmAb, timeout);
            assert (flag == 2);
        }
        catch (TimeoutException ex) {
            throw new ExternalFrameConfirmationException("Timeout for confirmation exceeded!");
        }
        catch (InterruptedException e) {
            throw new ExternalFrameConfirmationException("Confirmation thread interrupted!");
        }
        catch (ExecutionException e) {
            throw new ExternalFrameConfirmationException("Confirmation failed!");
        }
    }

    private void increaseCurrentColIdx() {
        this.currentColIdx = (this.currentColIdx + 1) % this.expectedTypes.length;
    }
}

