/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Arrays;
import water.H2O;
import water.nbhm.NonBlockingHashMap;

public class EnumUtils {
    private static NonBlockingHashMap<Class<? extends Enum>, NonBlockingHashMap<String, Enum>> enumMappings = new NonBlockingHashMap(150);

    public static String[] getNames(Class<? extends Enum<?>> e) {
        return Arrays.toString(e.getEnumConstants()).replaceAll("^.|.$", "").split(", ");
    }

    public static <T extends Enum<T>> T valueOf(Class<T> clz, String name) {
        String unifName;
        Enum value;
        NonBlockingHashMap<String, Enum> map = enumMappings.get(clz);
        if (map == null) {
            Enum[] enumValues = (Enum[])clz.getEnumConstants();
            map = new NonBlockingHashMap(enumValues.length * 2);
            for (Enum item : enumValues) {
                String origName = item.name();
                String unifName2 = origName.toUpperCase().replaceAll("[^0-9A-Z]", "");
                if (map.containsKey(origName)) {
                    throw H2O.fail("Unexpected key " + origName + " in enum " + clz);
                }
                if (map.containsKey(unifName2)) {
                    throw H2O.fail("Non-unique key " + unifName2 + " in enum " + clz);
                }
                map.put(origName, item);
                map.put(unifName2, item);
            }
            enumMappings.put(clz, map);
        }
        if ((value = map.get(name)) == null && name != null && (value = map.get(unifName = name.toUpperCase().replaceAll("[^0-9A-Z]", ""))) != null) {
            map.put(name, value);
        }
        if (value == null) {
            throw new IllegalArgumentException("No enum constant " + clz.getCanonicalName() + "." + name);
        }
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        return (T)value;
    }

    public static <T extends Enum<?>> T valueOfIgnoreCase(Class<T> enumeration, String value) {
        for (Enum field : (Enum[])enumeration.getEnumConstants()) {
            if (field.name().compareToIgnoreCase(value) != 0) continue;
            return (T)field;
        }
        return null;
    }
}

