/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.Arrays;
import water.DKV;
import water.Iced;
import water.Job;
import water.Key;
import water.fvec.CreateInteractions;
import water.fvec.Frame;
import water.util.Log;
import water.util.PrettyPrint;

public class Interaction
extends Iced {
    public Job<Frame> _job;
    public Key<Frame> _source_frame;
    public String[] _factor_columns;
    public boolean _pairwise = false;
    public int _max_factors = 100;
    public int _min_occurrence = 1;
    public boolean _interactOnNA = true;
    public transient int[] _factors = new int[0];

    public Job<Frame> execImpl(Key<Frame> dest) {
        this._job = new Job(dest == null ? Key.make() : dest, Frame.class.getName(), "CreateFrame");
        Frame source_frame = (Frame)DKV.getGet(this._source_frame);
        assert (source_frame != null);
        if (this._factor_columns == null || this._factor_columns.length == 0) {
            throw new IllegalArgumentException("factor_columns must be specified.");
        }
        if (this._pairwise && this._factor_columns.length < 3) {
            Log.info("Ignoring the pairwise option, requires 3 or more factors.");
        }
        this._factors = new int[this._factor_columns.length];
        int count = 0;
        for (String v : this._factor_columns) {
            int idx = source_frame.find(v);
            if (idx >= 0) {
                if (!source_frame.vecs()[idx].isCategorical()) {
                    throw new IllegalArgumentException("Column " + v + " is not categorical.");
                }
            } else {
                throw new IllegalArgumentException("Column " + v + " not found.");
            }
            this._factors[count++] = idx;
        }
        CreateInteractions in = new CreateInteractions(this);
        return this._job.start(in, in.work());
    }

    public String toString() {
        Frame res = this._job.get();
        if (res == null) {
            return "Output frame not found";
        }
        if (!this._pairwise) {
            return "Created interaction feature " + res.names()[0] + " (order: " + this._factors.length + ") with " + res.lastVec().domain().length + " factor levels in" + PrettyPrint.msecs(this._job.msec(), true);
        }
        return "Created " + res.numCols() + " pair-wise interaction features " + Arrays.deepToString(res.names()) + " (order: 2) in" + PrettyPrint.msecs(this._job.msec(), true);
    }
}

