/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.grid.Grid;
import hex.schemas.HyperSpaceSearchCriteriaV99;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import water.H2O;
import water.Key;
import water.api.API;
import water.api.Schema;
import water.api.schemas3.JobV3;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelParametersSchemaV3;
import water.api.schemas3.SchemaV3;
import water.exceptions.H2OIllegalArgumentException;
import water.nbhm.NonBlockingHashMap;
import water.util.IcedHashMap;
import water.util.JSONUtils;

public class GridSearchSchema<G extends Grid<MP>, S extends GridSearchSchema<G, S, MP, P>, MP extends Model.Parameters, P extends ModelParametersSchemaV3>
extends SchemaV3<G, S> {
    @API(help="Basic model builder parameters.", direction=API.Direction.INPUT)
    public P parameters;
    @API(help="Grid search parameters.", direction=API.Direction.INOUT)
    public IcedHashMap<String, Object[]> hyper_parameters;
    @API(help="Destination id for this grid; auto-generated if not specified.", direction=API.Direction.INOUT)
    public KeyV3.GridKeyV3 grid_id;
    @API(help="Hyperparameter search criteria, including strategy and early stopping directives.  If it is not given, exhaustive Cartesian is used.", required=false, direction=API.Direction.INOUT)
    public HyperSpaceSearchCriteriaV99 search_criteria;
    @API(help="Level of parallelism during grid model building. 1 = sequential building (default). 0 for adaptive parallelism.Any number > 1 sets the exact number of models built in parallel.")
    public int parallelism;
    @API(help="Number of all models generated by grid search.", direction=API.Direction.OUTPUT)
    public int total_models;
    @API(help="Job Key.", direction=API.Direction.OUTPUT)
    public JobV3 job;
    private static final int SEQUENTIAL_GRID_SEARCH = 1;

    @Override
    public S fillFromParms(Properties parms) {
        if (parms.containsKey("hyper_parameters")) {
            try {
                NonBlockingHashMap<String, Object> m = JSONUtils.parse(parms.getProperty("hyper_parameters"));
                for (Map.Entry e : m.entrySet()) {
                    Object[] objectArray;
                    Object o = e.getValue();
                    if (o instanceof List) {
                        objectArray = ((List)o).toArray();
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = o;
                    }
                    Object[] o2 = objectArray;
                    this.hyper_parameters.put((String)e.getKey(), o2);
                }
            }
            catch (Exception e) {
                throw new H2OIllegalArgumentException("Can't parse the hyper_parameters dictionary; got error: " + e.getMessage() + " for raw value: " + parms.getProperty("hyper_parameters"));
            }
            parms.remove("hyper_parameters");
        }
        if (parms.containsKey("search_criteria")) {
            try {
                Properties p = JSONUtils.parseToProperties(parms.getProperty("search_criteria"));
                if (!p.containsKey("strategy")) {
                    throw new H2OIllegalArgumentException("search_criteria.strategy", "null");
                }
                String strategy = (String)p.get("strategy");
                if ("Cartesian".equals(strategy)) {
                    this.search_criteria = new HyperSpaceSearchCriteriaV99.CartesianSearchCriteriaV99();
                } else if ("RandomDiscrete".equals(strategy)) {
                    this.search_criteria = new HyperSpaceSearchCriteriaV99.RandomDiscreteValueSearchCriteriaV99();
                    if (p.containsKey("max_runtime_secs") && Double.parseDouble((String)p.get("max_runtime_secs")) < 0.0) {
                        throw new H2OIllegalArgumentException("max_runtime_secs must be >= 0 (0 for unlimited time)", strategy);
                    }
                    if (p.containsKey("max_models") && Integer.parseInt((String)p.get("max_models")) < 0) {
                        throw new H2OIllegalArgumentException("max_models must be >= 0 (0 for all models)", strategy);
                    }
                } else {
                    throw new H2OIllegalArgumentException("search_criteria.strategy", strategy);
                }
                this.search_criteria.fillWithDefaults();
                this.search_criteria.fillFromParms(p);
            }
            catch (Exception e) {
                throw new H2OIllegalArgumentException("Can't parse the search_criteria dictionary; got error: " + e.getMessage() + " for raw value: " + parms.getProperty("search_criteria"));
            }
            parms.remove("search_criteria");
        } else {
            this.search_criteria = new HyperSpaceSearchCriteriaV99.CartesianSearchCriteriaV99();
        }
        if (parms.containsKey("grid_id")) {
            this.grid_id = new KeyV3.GridKeyV3(Key.make(parms.getProperty("grid_id")));
            parms.remove("grid_id");
        }
        if (parms.containsKey("parallelism")) {
            String parallelismProperty = parms.getProperty("parallelism");
            try {
                this.parallelism = Integer.parseInt(parallelismProperty);
                if (this.parallelism < 0) {
                    throw new IllegalArgumentException(String.format("Parallelism level must be >= 0. Given value: '%d'", this.parallelism));
                }
            }
            catch (NumberFormatException e) {
                String errorMessage = String.format("Could not parse given parallelism value: '%s' - not a number.", parallelismProperty);
                throw new IllegalArgumentException(errorMessage, e);
            }
            parms.remove("parallelism");
        } else {
            this.parallelism = 1;
        }
        ((Schema)this.parameters).fillFromParms(parms, false);
        return (S)this;
    }

    @Override
    public S fillFromImpl(G impl) {
        throw H2O.unimpl();
    }
}

