/*
 * Decompiled with CFR 0.152.
 */
package water;

import hex.Model;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Key;
import water.MRTask;
import water.TypeMap;
import water.Value;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;

public class DKVManager {
    public static void retain(Key[] retainedKeys) {
        HashSet<Key> retainedSet = new HashSet<Key>(retainedKeys.length);
        retainedSet.addAll(Arrays.asList(retainedKeys));
        DKVManager.extractNestedKeys(retainedSet);
        new ClearDKVTask(retainedSet.toArray(new Key[retainedSet.size()])).doAllNodes();
    }

    private static void extractNestedKeys(Set<Key> retainedKeys) throws IllegalArgumentException {
        Iterator<Key> keysIterator = retainedKeys.iterator();
        HashSet<Key> newKeys = new HashSet<Key>();
        while (keysIterator.hasNext()) {
            Key key = keysIterator.next();
            Value value = DKV.get(key);
            if (value == null || value.isNull()) continue;
            if (!value.isFrame() && !value.isModel()) {
                throw new IllegalArgumentException(String.format("Given key %s is of type %d. Please provide only Model and Frame keys.", key.toString(), value.type()));
            }
            if (value.isFrame()) {
                DKVManager.extractFrameKeys(newKeys, (Frame)value.get());
                continue;
            }
            if (!value.isModel()) continue;
            DKVManager.extractModelKeys(newKeys, (Model)value.get());
        }
        retainedKeys.addAll(newKeys);
    }

    private static void extractFrameKeys(Set<Key> retainedkeys, Frame frame) {
        Key<Vec>[] frameKeys;
        Objects.requireNonNull(frame);
        for (Key<Vec> k : frameKeys = frame.keys()) {
            retainedkeys.add(k);
        }
    }

    private static void extractModelKeys(Set<Key> retainedKeys, Model model) {
        Objects.requireNonNull(model);
        if (((Model.Parameters)model._parms)._train != null) {
            retainedKeys.add(((Model.Parameters)model._parms)._train);
            DKVManager.extractFrameKeys(retainedKeys, ((Model.Parameters)model._parms)._train.get());
        }
        if (((Model.Parameters)model._parms)._valid != null) {
            retainedKeys.add(((Model.Parameters)model._parms)._valid);
            DKVManager.extractFrameKeys(retainedKeys, ((Model.Parameters)model._parms)._valid.get());
        }
    }

    private static class ClearDKVTask
    extends MRTask<ClearDKVTask> {
        private final Key[] _retainedKeys;

        public ClearDKVTask(Key[] retainedKeys) {
            this._retainedKeys = retainedKeys;
        }

        @Override
        protected void setupLocal() {
            HashSet<Key> retainedKeys = new HashSet<Key>(this._retainedKeys.length);
            retainedKeys.addAll(Arrays.asList(this._retainedKeys));
            Collection<Value> storeKeys = H2O.STORE.values();
            Futures removalFutures = new Futures();
            for (Value value : storeKeys) {
                if (retainedKeys.contains(value._key)) continue;
                try {
                    TypeMap.getTheFreezableOrThrow(value.type());
                    if (value.isNull()) continue;
                    if (value.isFrame()) {
                        ((Frame)value.get()).retain(removalFutures, retainedKeys);
                        continue;
                    }
                    if (!value.isModel()) continue;
                    ((Model)value.get()).remove(removalFutures);
                }
                catch (ClassNotFoundException e) {
                    Log.debug(e);
                }
            }
            removalFutures.blockForPending();
        }
    }
}

