/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import water.AutoBuffer;
import water.ExternalBackendRequestType;
import water.ExternalFrameReaderBackend;
import water.ExternalFrameWriterBackend;

final class ExternalFrameHandler {
    static final byte NUM_MARKER_NEXT_BYTE_FOLLOWS = 127;
    static final String STR_MARKER_NEXT_BYTE_FOLLOWS = "\u0080";
    static final byte MARKER_ORIGINAL_VALUE = 0;
    static final byte MARKER_NA = 1;
    static final byte INIT_BYTE = 42;

    ExternalFrameHandler() {
    }

    void process(ByteChannel sock, AutoBuffer ab) throws IOException {
        ExternalBackendRequestType requestType = ExternalBackendRequestType.fromByte(ab.get1());
        switch (requestType) {
            case WRITE_TO_CHUNK: {
                ExternalFrameWriterBackend.writeToChunk(sock, ab);
                break;
            }
            case DOWNLOAD_FRAME: {
                ExternalFrameReaderBackend.readFromChunk(sock, ab);
            }
            case INIT_FRAME: {
                ExternalFrameWriterBackend.initFrame(sock, ab);
                break;
            }
            case FINALIZE_FRAME: {
                ExternalFrameWriterBackend.finalizeFrame(sock, ab);
            }
        }
    }
}

