/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.util.UUID;
import water.AutoBuffer;
import water.DKV;
import water.ExternalFrameUtils;
import water.fvec.Chunk;
import water.fvec.ChunkUtils;
import water.fvec.Frame;
import water.parser.BufferedString;

final class ExternalFrameReaderBackend {
    ExternalFrameReaderBackend() {
    }

    static void readFromChunk(ByteChannel channel, AutoBuffer initAb) throws IOException {
        String frameKey = initAb.getStr();
        int chunkIdx = initAb.getInt();
        byte[] expectedTypes = initAb.getA1();
        assert (expectedTypes != null) : "Expected types can't be null";
        int[] selectedColumnIndices = initAb.getA4();
        assert (selectedColumnIndices != null) : "Selected column indices can't be null";
        Frame fr = (Frame)DKV.getGet(frameKey);
        Chunk[] chunks = ChunkUtils.getChunks(fr, chunkIdx);
        AutoBuffer ab = new AutoBuffer();
        ab.putInt(chunks[0]._len);
        ExternalFrameUtils.writeToChannel(ab, channel);
        BufferedString valStr = new BufferedString();
        for (int rowIdx = 0; rowIdx < chunks[0]._len; ++rowIdx) {
            block13: for (int i = 0; i < selectedColumnIndices.length; ++i) {
                if (chunks[selectedColumnIndices[i]].isNA(rowIdx)) {
                    ExternalFrameUtils.sendNA(ab, expectedTypes[i]);
                    continue;
                }
                Chunk chnk = chunks[selectedColumnIndices[i]];
                switch (expectedTypes[i]) {
                    case 0: {
                        ExternalFrameUtils.sendBoolean(ab, (byte)chnk.at8(rowIdx));
                        continue block13;
                    }
                    case 1: {
                        ExternalFrameUtils.sendByte(ab, (byte)chnk.at8(rowIdx));
                        continue block13;
                    }
                    case 2: {
                        ExternalFrameUtils.sendChar(ab, (char)chnk.at8(rowIdx));
                        continue block13;
                    }
                    case 3: {
                        ExternalFrameUtils.sendShort(ab, (short)chnk.at8(rowIdx));
                        continue block13;
                    }
                    case 4: {
                        ExternalFrameUtils.sendInt(ab, (int)chnk.at8(rowIdx));
                        continue block13;
                    }
                    case 5: {
                        ExternalFrameUtils.sendFloat(ab, (float)chnk.atd(rowIdx));
                        continue block13;
                    }
                    case 6: {
                        ExternalFrameUtils.sendLong(ab, chnk.at8(rowIdx));
                        continue block13;
                    }
                    case 7: {
                        ExternalFrameUtils.sendDouble(ab, chnk.atd(rowIdx));
                        continue block13;
                    }
                    case 9: {
                        ExternalFrameUtils.sendTimestamp(ab, chnk.at8(rowIdx));
                        continue block13;
                    }
                    case 8: {
                        if (chnk.vec().isCategorical()) {
                            ExternalFrameUtils.sendString(ab, chnk.vec().domain()[(int)chnk.at8(rowIdx)]);
                            continue block13;
                        }
                        if (chnk.vec().isString()) {
                            ExternalFrameUtils.sendString(ab, chnk.atStr(valStr, rowIdx).toString());
                            continue block13;
                        }
                        if (chnk.vec().isUUID()) {
                            UUID uuid = new UUID(chnk.at16h(rowIdx), chnk.at16l(rowIdx));
                            ExternalFrameUtils.sendString(ab, uuid.toString());
                            continue block13;
                        }
                        assert (false) : "Can never be here";
                        continue block13;
                    }
                }
            }
        }
        ExternalFrameUtils.writeToChannel(ab, channel);
    }
}

