/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.sql.Timestamp;
import water.AutoBuffer;
import water.H2ONode;
import water.H2OSecurityManager;
import water.network.SocketChannelFactory;

public class ExternalFrameUtils {
    public static final byte EXPECTED_BOOL = 0;
    public static final byte EXPECTED_BYTE = 1;
    public static final byte EXPECTED_CHAR = 2;
    public static final byte EXPECTED_SHORT = 3;
    public static final byte EXPECTED_INT = 4;
    public static final byte EXPECTED_FLOAT = 5;
    public static final byte EXPECTED_LONG = 6;
    public static final byte EXPECTED_DOUBLE = 7;
    public static final byte EXPECTED_STRING = 8;
    public static final byte EXPECTED_TIMESTAMP = 9;
    public static final byte EXPECTED_VECTOR = 10;
    public static final int[] EMPTY_ARI = new int[0];
    public static final boolean VECTOR_IS_SPARSE = true;
    public static final boolean VECTOR_IS_DENSE = false;

    public static ByteChannel getConnection(String h2oNodeHostname, int h2oNodeApiPort, short nodeTimeStamp) throws IOException {
        SocketChannelFactory socketFactory = SocketChannelFactory.instance(H2OSecurityManager.instance());
        return H2ONode.openChan((byte)3, socketFactory, h2oNodeHostname, h2oNodeApiPort + 1, nodeTimeStamp);
    }

    public static ByteChannel getConnection(String ipPort, short nodeTimeStamp) throws IOException {
        String[] split = ipPort.split(":");
        return ExternalFrameUtils.getConnection(split[0], Integer.parseInt(split[1]), nodeTimeStamp);
    }

    public static byte[] vecTypesFromExpectedTypes(byte[] expectedTypes, int[] vecElemSizes) {
        assert (vecElemSizes != null) : "vecElemSizes should be not null!";
        int size = expectedTypes.length;
        size -= vecElemSizes.length;
        for (int vecSize : vecElemSizes) {
            size += vecSize;
        }
        byte[] vecTypes = new byte[size];
        int vectorCount = 0;
        int currentVecIdx = 0;
        block14: for (byte expectedType : expectedTypes) {
            switch (expectedType) {
                case 0: {
                    vecTypes[currentVecIdx] = 3;
                    ++currentVecIdx;
                    continue block14;
                }
                case 1: {
                    vecTypes[currentVecIdx] = 3;
                    ++currentVecIdx;
                    continue block14;
                }
                case 2: {
                    vecTypes[currentVecIdx] = 3;
                    ++currentVecIdx;
                    continue block14;
                }
                case 3: {
                    vecTypes[currentVecIdx] = 3;
                    ++currentVecIdx;
                    continue block14;
                }
                case 4: {
                    vecTypes[currentVecIdx] = 3;
                    ++currentVecIdx;
                    continue block14;
                }
                case 6: {
                    vecTypes[currentVecIdx] = 3;
                    ++currentVecIdx;
                    continue block14;
                }
                case 5: {
                    vecTypes[currentVecIdx] = 3;
                    ++currentVecIdx;
                    continue block14;
                }
                case 7: {
                    vecTypes[currentVecIdx] = 3;
                    ++currentVecIdx;
                    continue block14;
                }
                case 8: {
                    vecTypes[currentVecIdx] = 2;
                    ++currentVecIdx;
                    continue block14;
                }
                case 9: {
                    vecTypes[currentVecIdx] = 5;
                    ++currentVecIdx;
                    continue block14;
                }
                case 10: {
                    for (int j = 0; j < vecElemSizes[vectorCount]; ++j) {
                        vecTypes[currentVecIdx] = 3;
                        ++currentVecIdx;
                    }
                    ++vectorCount;
                    continue block14;
                }
                default: {
                    throw new IllegalArgumentException("Unknown expected type: " + expectedType);
                }
            }
        }
        assert (vecElemSizes.length == vectorCount) : "Inconsistency in passed parameters: vectors lenght specified, but no vector found";
        return vecTypes;
    }

    static void sendIntArray(AutoBuffer ab, int[] data) {
        ab.putA4(data);
    }

    static void sendDoubleArray(AutoBuffer ab, double[] data) {
        ab.putA8d(data);
    }

    static void sendBoolean(AutoBuffer ab, boolean data) {
        ExternalFrameUtils.sendBoolean(ab, data ? (byte)1 : 0);
    }

    static void sendBoolean(AutoBuffer ab, byte boolData) {
        ab.put1(boolData);
        ExternalFrameUtils.putMarker(ab, boolData);
    }

    static void sendByte(AutoBuffer ab, byte data) {
        ab.put1(data);
        ExternalFrameUtils.putMarker(ab, data);
    }

    static void sendChar(AutoBuffer ab, char data) {
        ab.put2(data);
        ExternalFrameUtils.putMarker(ab, data);
    }

    static void sendShort(AutoBuffer ab, short data) {
        ab.put2s(data);
        ExternalFrameUtils.putMarker(ab, data);
    }

    static void sendInt(AutoBuffer ab, int data) {
        ab.putInt(data);
        ExternalFrameUtils.putMarker(ab, data);
    }

    static void sendLong(AutoBuffer ab, long data) {
        ab.put8(data);
        ExternalFrameUtils.putMarker(ab, data);
    }

    static void sendFloat(AutoBuffer ab, float data) {
        ab.put4f(data);
    }

    static void sendDouble(AutoBuffer ab, double data) {
        ab.put8d(data);
    }

    static void sendString(AutoBuffer ab, String data) {
        ab.putStr(data);
        if (data != null && data.equals("\u0080")) {
            ab.put1(0);
        }
    }

    static void sendTimestamp(AutoBuffer ab, long time) {
        ExternalFrameUtils.sendLong(ab, time);
    }

    static void sendTimestamp(AutoBuffer ab, Timestamp data) {
        ExternalFrameUtils.sendLong(ab, data.getTime());
    }

    static void sendNA(AutoBuffer ab, byte expectedType) {
        switch (expectedType) {
            case 0: 
            case 1: {
                ab.put1(127);
                ab.put1(1);
                break;
            }
            case 2: {
                ab.put2((short)127);
                ab.put1(1);
                break;
            }
            case 3: {
                ab.put2s((short)127);
                ab.put1(1);
                break;
            }
            case 4: {
                ab.putInt(127);
                ab.put1(1);
                break;
            }
            case 6: 
            case 9: {
                ab.put8(127L);
                ab.put1(1);
                break;
            }
            case 5: {
                ab.put4f(Float.NaN);
                break;
            }
            case 7: {
                ab.put8d(Double.NaN);
                break;
            }
            case 8: {
                ab.putStr("\u0080");
                ab.put1(1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown expected type " + expectedType);
            }
        }
    }

    public static boolean isNA(AutoBuffer ab, boolean data) {
        return ExternalFrameUtils.isNA(ab, data ? 1L : 0L);
    }

    public static boolean isNA(AutoBuffer ab, long data) {
        return data == 127L && ab.get1() == 1;
    }

    public static boolean isNA(double data) {
        return Double.isNaN(data);
    }

    public static boolean isNA(AutoBuffer ab, Timestamp data) {
        return ExternalFrameUtils.isNA(ab, data.getTime());
    }

    public static boolean isNA(AutoBuffer ab, String data) {
        return data != null && data.equals("\u0080") && ab.get1() == 1;
    }

    static int[] getStartPositions(int[] elemSizes) {
        int[] startPos = new int[elemSizes.length];
        for (int i = 1; i < elemSizes.length; ++i) {
            startPos[i] = startPos[i - 1] + elemSizes[i - 1];
        }
        return startPos;
    }

    static int[] getElemSizes(byte[] expectedTypes, int[] vecElemSizes) {
        assert (vecElemSizes != null) : "vecElemSizes should be not null!";
        int vecCount = 0;
        int[] elemSizes = new int[expectedTypes.length];
        block4: for (int i = 0; i < expectedTypes.length; ++i) {
            switch (expectedTypes[i]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    elemSizes[i] = 1;
                    continue block4;
                }
                case 10: {
                    elemSizes[i] = vecElemSizes[vecCount++];
                }
            }
        }
        assert (vecElemSizes.length == vecCount) : "Inconsistency in passed parameters: vectors lenght specified, but no vector found";
        return elemSizes;
    }

    private static void putMarker(AutoBuffer ab, long data) {
        if (data == 127L) {
            ab.put1(0);
        }
    }

    public static void writeToChannel(AutoBuffer ab, ByteChannel channel) throws IOException {
        ab.flipForReading();
        channel.write(ab._bb);
        ab.clearForWriting((byte)126);
    }
}

